/*
 * Decompiled with CFR 0.152.
 */
package sound.jarnbjo.util.io;

import java.io.IOException;
import sound.jarnbjo.util.io.BitInputStream;
import sound.jarnbjo.util.io.HuffmanNode;

public class ByteArrayBitInputStream
implements BitInputStream {
    private byte[] source;
    private byte currentByte;
    private int endian;
    private int byteIndex = 0;
    private int bitIndex = 0;

    public ByteArrayBitInputStream(byte[] byArray) {
        this(byArray, 0);
    }

    public ByteArrayBitInputStream(byte[] byArray, int n) {
        this.endian = n;
        this.source = byArray;
        this.currentByte = byArray[0];
        this.bitIndex = n == 0 ? 0 : 7;
    }

    @Override
    public boolean getBit() throws IOException {
        if (this.endian == 0) {
            if (this.bitIndex > 7) {
                this.bitIndex = 0;
                this.currentByte = this.source[++this.byteIndex];
            }
            return (this.currentByte & 1 << this.bitIndex++) != 0;
        }
        if (this.bitIndex < 0) {
            this.bitIndex = 7;
            this.currentByte = this.source[++this.byteIndex];
        }
        return (this.currentByte & 1 << this.bitIndex--) != 0;
    }

    @Override
    public int getInt(int n) throws IOException {
        if (n > 32) {
            throw new IllegalArgumentException("Argument \"bits\" must be <= 32");
        }
        int n2 = 0;
        if (this.endian == 0) {
            for (int i = 0; i < n; ++i) {
                if (!this.getBit()) continue;
                n2 |= 1 << i;
            }
        } else {
            if (this.bitIndex < 0) {
                this.bitIndex = 7;
                this.currentByte = this.source[++this.byteIndex];
            }
            if (n <= this.bitIndex + 1) {
                int n3 = this.currentByte & 0xFF;
                int n4 = 1 + this.bitIndex - n;
                int n5 = (1 << n) - 1 << n4;
                n2 = (n3 & n5) >> n4;
                this.bitIndex -= n;
            } else {
                n2 = (this.currentByte & 0xFF & (1 << this.bitIndex + 1) - 1) << n - this.bitIndex - 1;
                n -= this.bitIndex + 1;
                this.currentByte = this.source[++this.byteIndex];
                while (n >= 8) {
                    n2 |= (this.source[this.byteIndex] & 0xFF) << (n -= 8);
                    this.currentByte = this.source[++this.byteIndex];
                }
                if (n > 0) {
                    int n6 = this.source[this.byteIndex] & 0xFF;
                    n2 |= n6 >> 8 - n & (1 << n) - 1;
                    this.bitIndex = 7 - n;
                } else {
                    this.currentByte = this.source[--this.byteIndex];
                    this.bitIndex = -1;
                }
            }
        }
        return n2;
    }

    @Override
    public int getSignedInt(int n) throws IOException {
        int n2 = this.getInt(n);
        if (n2 >= 1 << n - 1) {
            n2 -= 1 << n;
        }
        return n2;
    }

    @Override
    public int getInt(HuffmanNode huffmanNode) throws IOException {
        while (huffmanNode.value == null) {
            if (this.bitIndex > 7) {
                this.bitIndex = 0;
                this.currentByte = this.source[++this.byteIndex];
            }
            huffmanNode = (this.currentByte & 1 << this.bitIndex++) != 0 ? huffmanNode.o1 : huffmanNode.o0;
        }
        return huffmanNode.value;
    }

    @Override
    public long getLong(int n) throws IOException {
        if (n > 64) {
            throw new IllegalArgumentException("Argument \"bits\" must be <= 64");
        }
        long l = 0L;
        if (this.endian == 0) {
            for (int i = 0; i < n; ++i) {
                if (!this.getBit()) continue;
                l |= 1L << i;
            }
        } else {
            for (int i = n - 1; i >= 0; --i) {
                if (!this.getBit()) continue;
                l |= 1L << i;
            }
        }
        return l;
    }

    @Override
    public int readSignedRice(int n) throws IOException {
        int n2 = -1;
        int n3 = 0;
        int n4 = 0;
        if (this.endian == 0) {
            throw new UnsupportedOperationException("ByteArrayBitInputStream.readSignedRice() is only supported in big endian mode");
        }
        byte by = this.source[this.byteIndex];
        do {
            ++n2;
            if (this.bitIndex >= 0) continue;
            this.bitIndex = 7;
            ++this.byteIndex;
            by = this.source[this.byteIndex];
        } while ((by & 1 << this.bitIndex--) == 0);
        int n5 = n;
        if (this.bitIndex < 0) {
            this.bitIndex = 7;
            ++this.byteIndex;
        }
        if (n5 <= this.bitIndex + 1) {
            int n6 = this.source[this.byteIndex] & 0xFF;
            int n7 = 1 + this.bitIndex - n5;
            int n8 = (1 << n5) - 1 << n7;
            n3 = (n6 & n8) >> n7;
            this.bitIndex -= n5;
        } else {
            n3 = (this.source[this.byteIndex] & 0xFF & (1 << this.bitIndex + 1) - 1) << n5 - this.bitIndex - 1;
            n5 -= this.bitIndex + 1;
            ++this.byteIndex;
            while (n5 >= 8) {
                n3 |= (this.source[this.byteIndex] & 0xFF) << (n5 -= 8);
                ++this.byteIndex;
            }
            if (n5 > 0) {
                int n9 = this.source[this.byteIndex] & 0xFF;
                n3 |= n9 >> 8 - n5 & (1 << n5) - 1;
                this.bitIndex = 7 - n5;
            } else {
                --this.byteIndex;
                this.bitIndex = -1;
            }
        }
        n4 = n2 << n | n3;
        return (n4 & 1) == 1 ? -(n4 >> 1) - 1 : n4 >> 1;
    }

    @Override
    public void readSignedRice(int n, int[] nArray, int n2, int n3) throws IOException {
        if (this.endian == 0) {
            throw new UnsupportedOperationException("ByteArrayBitInputStream.readSignedRice() is only supported in big endian mode");
        }
        for (int i = n2; i < n2 + n3; ++i) {
            int n4;
            int n5 = -1;
            int n6 = 0;
            byte by = this.source[this.byteIndex];
            do {
                ++n5;
                if (this.bitIndex >= 0) continue;
                this.bitIndex = 7;
                ++this.byteIndex;
                by = this.source[this.byteIndex];
            } while ((by & 1 << this.bitIndex--) == 0);
            int n7 = n;
            if (this.bitIndex < 0) {
                this.bitIndex = 7;
                ++this.byteIndex;
            }
            if (n7 <= this.bitIndex + 1) {
                n4 = this.source[this.byteIndex] & 0xFF;
                int n8 = 1 + this.bitIndex - n7;
                int n9 = (1 << n7) - 1 << n8;
                n6 = (n4 & n9) >> n8;
                this.bitIndex -= n7;
            } else {
                n6 = (this.source[this.byteIndex] & 0xFF & (1 << this.bitIndex + 1) - 1) << n7 - this.bitIndex - 1;
                n7 -= this.bitIndex + 1;
                ++this.byteIndex;
                while (n7 >= 8) {
                    n6 |= (this.source[this.byteIndex] & 0xFF) << (n7 -= 8);
                    ++this.byteIndex;
                }
                if (n7 > 0) {
                    n4 = this.source[this.byteIndex] & 0xFF;
                    n6 |= n4 >> 8 - n7 & (1 << n7) - 1;
                    this.bitIndex = 7 - n7;
                } else {
                    --this.byteIndex;
                    this.bitIndex = -1;
                }
            }
            n4 = n5 << n | n6;
            nArray[i] = (n4 & 1) == 1 ? -(n4 >> 1) - 1 : n4 >> 1;
        }
    }

    @Override
    public void align() {
        if (this.endian == 1 && this.bitIndex >= 0) {
            this.bitIndex = 7;
            ++this.byteIndex;
        } else if (this.endian == 0 && this.bitIndex <= 7) {
            this.bitIndex = 0;
            ++this.byteIndex;
        }
    }

    @Override
    public void setEndian(int n) {
        if (this.endian == 1 && n == 0) {
            this.bitIndex = 0;
            ++this.byteIndex;
        } else if (this.endian == 0 && n == 1) {
            this.bitIndex = 7;
            ++this.byteIndex;
        }
        this.endian = n;
    }

    public byte[] getSource() {
        return this.source;
    }
}

