/*
 * Decompiled with CFR 0.152.
 */
package sound.jarnbjo.vorbis;

import java.io.IOException;
import java.util.HashMap;
import sound.jarnbjo.util.io.BitInputStream;
import sound.jarnbjo.vorbis.CodeBook;
import sound.jarnbjo.vorbis.Mode;
import sound.jarnbjo.vorbis.Residue0;
import sound.jarnbjo.vorbis.Residue2;
import sound.jarnbjo.vorbis.SetupHeader;
import sound.jarnbjo.vorbis.Util;
import sound.jarnbjo.vorbis.VorbisFormatException;
import sound.jarnbjo.vorbis.VorbisStream;

public abstract class Residue {
    protected int begin;
    protected int end;
    protected int partitionSize;
    protected int classifications;
    protected int classBook;
    protected int[] cascade;
    protected int[][] books;
    protected HashMap looks = new HashMap();

    protected Residue() {
    }

    protected Residue(BitInputStream bitInputStream, SetupHeader setupHeader) throws VorbisFormatException, IOException {
        int n;
        int n2;
        this.begin = bitInputStream.getInt(24);
        this.end = bitInputStream.getInt(24);
        this.partitionSize = bitInputStream.getInt(24) + 1;
        this.classifications = bitInputStream.getInt(6) + 1;
        this.classBook = bitInputStream.getInt(8);
        this.cascade = new int[this.classifications];
        int n3 = 0;
        for (n2 = 0; n2 < this.classifications; ++n2) {
            n = 0;
            int n4 = 0;
            n4 = bitInputStream.getInt(3);
            if (bitInputStream.getBit()) {
                n = bitInputStream.getInt(5);
            }
            this.cascade[n2] = n << 3 | n4;
            n3 += Util.icount(this.cascade[n2]);
        }
        this.books = new int[this.classifications][8];
        for (n2 = 0; n2 < this.classifications; ++n2) {
            for (n = 0; n < 8; ++n) {
                if ((this.cascade[n2] & 1 << n) == 0) continue;
                this.books[n2][n] = bitInputStream.getInt(8);
                if (this.books[n2][n] <= setupHeader.getCodeBooks().length) continue;
                throw new VorbisFormatException("Reference to invalid codebook entry in residue header.");
            }
        }
    }

    protected static Residue createInstance(BitInputStream bitInputStream, SetupHeader setupHeader) throws VorbisFormatException, IOException {
        int n = bitInputStream.getInt(16);
        switch (n) {
            case 0: {
                return new Residue0(bitInputStream, setupHeader);
            }
            case 1: {
                return new Residue2(bitInputStream, setupHeader);
            }
            case 2: {
                return new Residue2(bitInputStream, setupHeader);
            }
        }
        throw new VorbisFormatException("Residue type " + n + " is not supported.");
    }

    protected abstract int getType();

    protected abstract void decodeResidue(VorbisStream var1, BitInputStream var2, Mode var3, int var4, boolean[] var5, float[][] var6) throws VorbisFormatException, IOException;

    protected int getBegin() {
        return this.begin;
    }

    protected int getEnd() {
        return this.end;
    }

    protected int getPartitionSize() {
        return this.partitionSize;
    }

    protected int getClassifications() {
        return this.classifications;
    }

    protected int getClassBook() {
        return this.classBook;
    }

    protected int[] getCascade() {
        return this.cascade;
    }

    protected int[][] getBooks() {
        return this.books;
    }

    protected final void fill(Residue residue) {
        residue.begin = this.begin;
        residue.books = this.books;
        residue.cascade = this.cascade;
        residue.classBook = this.classBook;
        residue.classifications = this.classifications;
        residue.end = this.end;
        residue.partitionSize = this.partitionSize;
    }

    protected Look getLook(VorbisStream vorbisStream, Mode mode) {
        Look look = (Look)this.looks.get(mode);
        if (look == null) {
            look = new Look(vorbisStream, mode);
            this.looks.put(mode, look);
        }
        return look;
    }

    class Look {
        int map;
        int parts;
        int stages;
        CodeBook[] fullbooks;
        CodeBook phrasebook;
        int[][] partbooks;
        int partvals;
        int[][] decodemap;
        int postbits;
        int phrasebits;
        int frames;

        protected Look(VorbisStream vorbisStream, Mode mode) {
            int n;
            int n2;
            int n3;
            int n4 = 0;
            boolean bl = false;
            int n5 = 0;
            this.map = mode.getMapping();
            this.parts = Residue.this.getClassifications();
            this.fullbooks = vorbisStream.getSetupHeader().getCodeBooks();
            this.phrasebook = this.fullbooks[Residue.this.getClassBook()];
            n4 = this.phrasebook.getDimensions();
            this.partbooks = new int[this.parts][];
            for (n3 = 0; n3 < this.parts; ++n3) {
                n2 = Util.ilog(Residue.this.getCascade()[n3]);
                if (n2 == 0) continue;
                if (n2 > n5) {
                    n5 = n2;
                }
                this.partbooks[n3] = new int[n2];
                for (n = 0; n < n2; ++n) {
                    if ((Residue.this.getCascade()[n3] & 1 << n) == 0) continue;
                    this.partbooks[n3][n] = Residue.this.getBooks()[n3][n];
                }
            }
            this.partvals = (int)Math.rint(Math.pow(this.parts, n4));
            this.stages = n5;
            this.decodemap = new int[this.partvals][];
            for (n3 = 0; n3 < this.partvals; ++n3) {
                n2 = n3;
                n = this.partvals / this.parts;
                this.decodemap[n3] = new int[n4];
                for (int i = 0; i < n4; ++i) {
                    int n6 = n2 / n;
                    n2 -= n6 * n;
                    n /= this.parts;
                    this.decodemap[n3][i] = n6;
                }
            }
        }

        protected int[][] getDecodeMap() {
            return this.decodemap;
        }

        protected int getFrames() {
            return this.frames;
        }

        protected int getMap() {
            return this.map;
        }

        protected int[][] getPartBooks() {
            return this.partbooks;
        }

        protected int getParts() {
            return this.parts;
        }

        protected int getPartVals() {
            return this.partvals;
        }

        protected int getPhraseBits() {
            return this.phrasebits;
        }

        protected CodeBook getPhraseBook() {
            return this.phrasebook;
        }

        protected int getPostBits() {
            return this.postbits;
        }

        protected int getStages() {
            return this.stages;
        }
    }
}

