/*
 * Decompiled with CFR 0.152.
 */
package sound.jarnbjo.vorbis;

import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.RandomAccessFile;
import java.net.URL;
import java.util.Collection;
import javax.sound.sampled.AudioFileFormat;
import javax.sound.sampled.AudioFormat;
import javax.sound.sampled.AudioInputStream;
import javax.sound.sampled.UnsupportedAudioFileException;
import javax.sound.sampled.spi.AudioFileReader;
import sound.jarnbjo.ogg.BasicStream;
import sound.jarnbjo.ogg.EndOfOggStreamException;
import sound.jarnbjo.ogg.FileStream;
import sound.jarnbjo.ogg.LogicalOggStream;
import sound.jarnbjo.ogg.OggFormatException;
import sound.jarnbjo.ogg.PhysicalOggStream;
import sound.jarnbjo.ogg.UncachedUrlStream;
import sound.jarnbjo.vorbis.VorbisFormatException;
import sound.jarnbjo.vorbis.VorbisStream;

public class VorbisAudioFileReader
extends AudioFileReader {
    @Override
    public AudioFileFormat getAudioFileFormat(File file) throws IOException, UnsupportedAudioFileException {
        try {
            return this.getAudioFileFormat(new FileStream(new RandomAccessFile(file, "r")));
        }
        catch (OggFormatException oggFormatException) {
            throw new UnsupportedAudioFileException(oggFormatException.getMessage());
        }
    }

    @Override
    public AudioFileFormat getAudioFileFormat(InputStream inputStream) throws IOException, UnsupportedAudioFileException {
        try {
            return this.getAudioFileFormat(new BasicStream(inputStream));
        }
        catch (OggFormatException oggFormatException) {
            throw new UnsupportedAudioFileException(oggFormatException.getMessage());
        }
    }

    @Override
    public AudioFileFormat getAudioFileFormat(URL uRL) throws IOException, UnsupportedAudioFileException {
        try {
            return this.getAudioFileFormat(new UncachedUrlStream(uRL));
        }
        catch (OggFormatException oggFormatException) {
            throw new UnsupportedAudioFileException(oggFormatException.getMessage());
        }
    }

    private AudioFileFormat getAudioFileFormat(PhysicalOggStream physicalOggStream) throws IOException, UnsupportedAudioFileException {
        try {
            Collection collection = physicalOggStream.getLogicalStreams();
            if (collection.size() != 1) {
                throw new UnsupportedAudioFileException("Only Ogg files with one logical Vorbis stream are supported.");
            }
            LogicalOggStream logicalOggStream = (LogicalOggStream)collection.iterator().next();
            if (logicalOggStream.getFormat() != "audio/x-vorbis") {
                throw new UnsupportedAudioFileException("Only Ogg files with one logical Vorbis stream are supported.");
            }
            VorbisStream vorbisStream = new VorbisStream(logicalOggStream);
            AudioFormat audioFormat = new AudioFormat(vorbisStream.getIdentificationHeader().getSampleRate(), 16, vorbisStream.getIdentificationHeader().getChannels(), true, true);
            return new AudioFileFormat(VorbisFormatType.getInstance(), audioFormat, -1);
        }
        catch (OggFormatException oggFormatException) {
            throw new UnsupportedAudioFileException(oggFormatException.getMessage());
        }
        catch (VorbisFormatException vorbisFormatException) {
            throw new UnsupportedAudioFileException(vorbisFormatException.getMessage());
        }
    }

    @Override
    public AudioInputStream getAudioInputStream(File file) throws IOException, UnsupportedAudioFileException {
        try {
            return this.getAudioInputStream(new FileStream(new RandomAccessFile(file, "r")));
        }
        catch (OggFormatException oggFormatException) {
            throw new UnsupportedAudioFileException(oggFormatException.getMessage());
        }
    }

    @Override
    public AudioInputStream getAudioInputStream(InputStream inputStream) throws IOException, UnsupportedAudioFileException {
        try {
            return this.getAudioInputStream(new BasicStream(inputStream));
        }
        catch (OggFormatException oggFormatException) {
            throw new UnsupportedAudioFileException(oggFormatException.getMessage());
        }
    }

    @Override
    public AudioInputStream getAudioInputStream(URL uRL) throws IOException, UnsupportedAudioFileException {
        try {
            return this.getAudioInputStream(new UncachedUrlStream(uRL));
        }
        catch (OggFormatException oggFormatException) {
            throw new UnsupportedAudioFileException(oggFormatException.getMessage());
        }
    }

    private AudioInputStream getAudioInputStream(PhysicalOggStream physicalOggStream) throws IOException, UnsupportedAudioFileException {
        try {
            Collection collection = physicalOggStream.getLogicalStreams();
            if (collection.size() != 1) {
                throw new UnsupportedAudioFileException("Only Ogg files with one logical Vorbis stream are supported.");
            }
            LogicalOggStream logicalOggStream = (LogicalOggStream)collection.iterator().next();
            if (logicalOggStream.getFormat() != "audio/x-vorbis") {
                throw new UnsupportedAudioFileException("Only Ogg files with one logical Vorbis stream are supported.");
            }
            VorbisStream vorbisStream = new VorbisStream(logicalOggStream);
            AudioFormat audioFormat = new AudioFormat(vorbisStream.getIdentificationHeader().getSampleRate(), 16, vorbisStream.getIdentificationHeader().getChannels(), true, true);
            return new AudioInputStream(new VorbisInputStream(vorbisStream), audioFormat, -1L);
        }
        catch (OggFormatException oggFormatException) {
            throw new UnsupportedAudioFileException(oggFormatException.getMessage());
        }
        catch (VorbisFormatException vorbisFormatException) {
            throw new UnsupportedAudioFileException(vorbisFormatException.getMessage());
        }
    }

    public static class VorbisInputStream
    extends InputStream {
        private VorbisStream source;
        private byte[] buffer = new byte[8192];

        public VorbisInputStream(VorbisStream vorbisStream) {
            this.source = vorbisStream;
        }

        @Override
        public int read() throws IOException {
            return 0;
        }

        @Override
        public int read(byte[] byArray) throws IOException {
            return this.read(byArray, 0, byArray.length);
        }

        @Override
        public int read(byte[] byArray, int n, int n2) throws IOException {
            try {
                return this.source.readPcm(byArray, n, n2);
            }
            catch (EndOfOggStreamException endOfOggStreamException) {
                return -1;
            }
        }
    }

    public static class VorbisFormatType
    extends AudioFileFormat.Type {
        private static final VorbisFormatType instance = new VorbisFormatType();

        private VorbisFormatType() {
            super("VORBIS", "ogg");
        }

        public static AudioFileFormat.Type getInstance() {
            return instance;
        }
    }
}

