/*
 * Decompiled with CFR 0.152.
 */
package sound.musicg.api;

import sound.musicg.math.rank.ArrayRankDouble;
import sound.musicg.math.statistics.StandardDeviation;
import sound.musicg.math.statistics.ZeroCrossingRate;
import sound.musicg.wave.Wave;
import sound.musicg.wave.WaveHeader;
import sound.musicg.wave.extension.Spectrogram;

public class DetectionApi {
    protected WaveHeader waveHeader;
    protected int fftSampleSize;
    protected int numFrequencyUnit;
    protected double unitFrequency;
    protected double minFrequency;
    protected double maxFrequency;
    protected double minIntensity;
    protected double maxIntensity;
    protected double minStandardDeviation;
    protected double maxStandardDeviation;
    protected int highPass;
    protected int lowPass;
    protected int minNumZeroCross;
    protected int maxNumZeroCross;
    protected int lowerBoundary;
    protected int upperBoundary;
    protected int numRobust;

    public DetectionApi(WaveHeader waveHeader) {
        if (waveHeader.getChannels() == 1) {
            this.waveHeader = waveHeader;
            this.init();
        } else {
            System.err.println("DetectionAPI supports mono Wav only");
        }
    }

    protected void init() {
    }

    public boolean isSpecificSound(byte[] byArray) {
        int n = this.waveHeader.getBitsPerSample() / 8;
        int n2 = byArray.length / n;
        if (n2 > 0 && Integer.bitCount(n2) == 1) {
            this.fftSampleSize = n2;
            this.numFrequencyUnit = this.fftSampleSize / 2;
            this.unitFrequency = (double)this.waveHeader.getSampleRate() / 2.0 / (double)this.numFrequencyUnit;
            this.lowerBoundary = (int)((double)this.highPass / this.unitFrequency);
            this.upperBoundary = (int)((double)this.lowPass / this.unitFrequency);
            Wave wave = new Wave(this.waveHeader, byArray);
            short[] sArray = wave.getSampleAmplitudes();
            Spectrogram spectrogram = wave.getSpectrogram(this.fftSampleSize, 0);
            double[][] dArray = spectrogram.getAbsoluteSpectrogramData();
            double[] dArray2 = dArray[0];
            int n3 = this.upperBoundary - this.lowerBoundary + 1;
            double[] dArray3 = new double[n3];
            System.arraycopy(dArray2, this.lowerBoundary, dArray3, 0, dArray3.length);
            if (n3 <= dArray2.length) {
                if (this.isPassedIntensity(dArray2) && this.isPassedStandardDeviation(dArray) && this.isPassedZeroCrossingRate(sArray) && this.isPassedFrequency(dArray3)) {
                    return true;
                }
            } else {
                System.err.println("is error: the wave needed to be higher sample rate");
            }
        } else {
            System.out.println("The sample size must be a power of 2");
        }
        return false;
    }

    protected void normalizeSpectrogramData(double[][] dArray) {
        double d = Double.MIN_VALUE;
        double d2 = Double.MAX_VALUE;
        for (int i = 0; i < dArray.length; ++i) {
            for (int j = 0; j < dArray[i].length; ++j) {
                if (dArray[i][j] > d) {
                    d = dArray[i][j];
                    continue;
                }
                if (!(dArray[i][j] < d2)) continue;
                d2 = dArray[i][j];
            }
        }
        double d3 = 1.0E-11f;
        if (d2 == 0.0) {
            d2 = d3;
        }
        double d4 = Math.log10(d / d2);
        for (int i = 0; i < dArray.length; ++i) {
            for (int j = 0; j < dArray[i].length; ++j) {
                dArray[i][j] = dArray[i][j] < d3 ? 0.0 : Math.log10(dArray[i][j] / d2) / d4;
            }
        }
    }

    protected boolean isPassedStandardDeviation(double[][] dArray) {
        this.normalizeSpectrogramData(dArray);
        double[] dArray2 = dArray[dArray.length - 1];
        double[] dArray3 = new double[this.numRobust];
        ArrayRankDouble arrayRankDouble = new ArrayRankDouble();
        double d = arrayRankDouble.getNthOrderedValue(dArray2, this.numRobust, false);
        int n = 0;
        for (int i = 0; i < dArray2.length; ++i) {
            if (!(dArray2[i] >= d)) continue;
            dArray3[n++] = dArray2[i];
            if (n >= this.numRobust) break;
        }
        StandardDeviation standardDeviation = new StandardDeviation();
        standardDeviation.setValues(dArray3);
        double d2 = standardDeviation.evaluate();
        boolean bl = d2 >= this.minStandardDeviation && d2 <= this.maxStandardDeviation;
        return bl;
    }

    protected boolean isPassedFrequency(double[] dArray) {
        ArrayRankDouble arrayRankDouble = new ArrayRankDouble();
        double d = (double)arrayRankDouble.getMaxValueIndex(dArray) * this.unitFrequency;
        boolean bl = d >= this.minFrequency && d <= this.maxFrequency;
        return bl;
    }

    protected boolean isPassedIntensity(double[] dArray) {
        boolean bl;
        double d = 0.0;
        for (bl = false; bl < dArray.length; bl += 1) {
            d += dArray[bl];
        }
        bl = (d /= (double)dArray.length) > this.minIntensity && d <= this.maxIntensity;
        return bl;
    }

    protected boolean isPassedZeroCrossingRate(short[] sArray) {
        ZeroCrossingRate zeroCrossingRate = new ZeroCrossingRate(sArray, 1.0);
        int n = (int)zeroCrossingRate.evaluate();
        boolean bl = n >= this.minNumZeroCross && n <= this.maxNumZeroCross;
        return bl;
    }
}

