/*
 * Decompiled with CFR 0.152.
 */
package sound.musicg.graphic;

import java.awt.Color;
import java.awt.Graphics2D;
import java.awt.image.BufferedImage;
import java.awt.image.RenderedImage;
import java.io.File;
import java.io.IOException;
import javax.imageio.ImageIO;
import sound.musicg.wave.Wave;
import sound.musicg.wave.extension.Spectrogram;

public class GraphicRender {
    public static final float WAVEFORM_DEFAULT_TIMESTEP = 0.1f;
    private int xMarker = -1;
    private int yMarker = -1;

    public void renderWaveform(Wave wave, String string) {
        this.renderWaveform(wave, 0.1f, string);
    }

    public void renderWaveform(Wave wave, float f, String string) {
        double d = 0.0;
        if (wave.getWaveHeader().getBitsPerSample() == 8) {
            d = 0.5;
        }
        double[] dArray = wave.getNormalizedAmplitudes();
        int n = (int)((float)(dArray.length / wave.getWaveHeader().getSampleRate()) / f);
        int n2 = 500;
        int n3 = n2 / 2;
        int n4 = 1000;
        int n5 = dArray.length;
        if (n > 0) {
            int n6;
            int n7 = n5 / n;
            int[] nArray = new int[n];
            int[] nArray2 = new int[n];
            for (int i = 0; i < n; ++i) {
                int n8;
                double d2 = 0.0;
                double d3 = 0.0;
                int n9 = i * n7;
                for (n8 = 0; n8 < n7; ++n8) {
                    double d4 = dArray[n9 + n8];
                    if (d4 > d) {
                        d2 += d4 - d;
                        continue;
                    }
                    d3 += d4 - d;
                }
                n8 = (int)(d2 / (double)n7 * (double)n4 + (double)n3);
                int n10 = (int)(d3 / (double)n7 * (double)n4 + (double)n3);
                nArray[i] = n8;
                nArray2[i] = n10;
            }
            BufferedImage bufferedImage = new BufferedImage(n, n2, 1);
            Graphics2D graphics2D = bufferedImage.createGraphics();
            graphics2D.setPaint(new Color(255, 255, 255));
            graphics2D.fillRect(0, 0, bufferedImage.getWidth(), bufferedImage.getHeight());
            for (n6 = 0; n6 < n; ++n6) {
                for (int i = nArray2[n6]; i < nArray[n6]; ++i) {
                    int n11 = n2 - i;
                    if (n11 < 0) {
                        n11 = 0;
                    } else if (n11 >= n2) {
                        n11 = n2 - 1;
                    }
                    bufferedImage.setRGB(n6, n11, 0);
                }
            }
            try {
                n6 = string.lastIndexOf(".");
                String string2 = string.substring(n6 + 1);
                ImageIO.write((RenderedImage)bufferedImage, string2, new File(string));
            }
            catch (IOException iOException) {
                iOException.printStackTrace();
            }
        } else {
            System.err.println("renderWaveform error: Empty Wave");
        }
    }

    public void renderSpectrogram(Spectrogram spectrogram, String string) {
        this.renderSpectrogramData(spectrogram.getNormalizedSpectrogramData(), string);
    }

    public void renderSpectrogramData(double[][] dArray, String string) {
        if (dArray != null) {
            int n;
            int n2 = dArray.length;
            int n3 = dArray[0].length;
            BufferedImage bufferedImage = new BufferedImage(n2, n3, 1);
            for (n = 0; n < n2; ++n) {
                int n4;
                if (n == this.xMarker) {
                    for (n4 = 0; n4 < n3; ++n4) {
                        bufferedImage.setRGB(n, n4, 65280);
                    }
                    continue;
                }
                for (n4 = 0; n4 < n3; ++n4) {
                    int n5 = n4 == this.yMarker ? 0xFF0000 : 255 - (int)(dArray[n][n4] * 255.0);
                    bufferedImage.setRGB(n, n3 - 1 - n4, n5 << 16 | n5 << 8 | n5);
                }
            }
            try {
                n = string.lastIndexOf(".");
                String string2 = string.substring(n + 1);
                ImageIO.write((RenderedImage)bufferedImage, string2, new File(string));
            }
            catch (IOException iOException) {
                iOException.printStackTrace();
            }
        } else {
            System.err.println("renderSpectrogramData error: Empty Wave");
        }
    }

    public void setVerticalMarker(int n) {
        this.xMarker = n;
    }

    public void setHorizontalMarker(int n) {
        this.yMarker = n;
    }

    public void resetMarkers() {
        this.xMarker = -1;
        this.yMarker = -1;
    }
}

