/*
 * Decompiled with CFR 0.152.
 */
package sound.musicg.processor;

import java.util.LinkedList;
import java.util.List;
import sound.musicg.processor.IntensityProcessor;
import sound.musicg.processor.RobustIntensityProcessor;

public class ProcessorChain {
    private double[][] intensities;
    List<IntensityProcessor> processorList = new LinkedList<IntensityProcessor>();

    public ProcessorChain(double[][] dArray) {
        this.intensities = dArray;
        RobustIntensityProcessor robustIntensityProcessor = new RobustIntensityProcessor(dArray, 1);
        this.processorList.add(robustIntensityProcessor);
        this.process();
    }

    private void process() {
        for (IntensityProcessor intensityProcessor : this.processorList) {
            intensityProcessor.execute();
            this.intensities = intensityProcessor.getIntensities();
        }
    }

    public double[][] getIntensities() {
        return this.intensities;
    }
}

