/*
 * Decompiled with CFR 0.152.
 */
package sound.musicg.wave;

import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.io.Serializable;
import sound.musicg.fingerprint.FingerprintManager;
import sound.musicg.fingerprint.FingerprintSimilarity;
import sound.musicg.fingerprint.FingerprintSimilarityComputer;
import sound.musicg.wave.WaveHeader;
import sound.musicg.wave.extension.NormalizedSampleAmplitudes;
import sound.musicg.wave.extension.Spectrogram;

public class Wave
implements Serializable {
    private static final long serialVersionUID = 1L;
    private WaveHeader waveHeader;
    private byte[] data;
    private byte[] fingerprint;

    public Wave() {
        this.waveHeader = new WaveHeader();
        this.data = new byte[0];
    }

    public Wave(String string) {
        try {
            FileInputStream fileInputStream = new FileInputStream(string);
            this.initWaveWithInputStream(fileInputStream);
            ((InputStream)fileInputStream).close();
        }
        catch (FileNotFoundException fileNotFoundException) {
            fileNotFoundException.printStackTrace();
        }
        catch (IOException iOException) {
            iOException.printStackTrace();
        }
    }

    public Wave(InputStream inputStream) {
        this.initWaveWithInputStream(inputStream);
    }

    public Wave(WaveHeader waveHeader, byte[] byArray) {
        this.waveHeader = waveHeader;
        this.data = byArray;
    }

    private void initWaveWithInputStream(InputStream inputStream) {
        this.waveHeader = new WaveHeader(inputStream);
        if (this.waveHeader.isValid()) {
            try {
                this.data = new byte[inputStream.available()];
                inputStream.read(this.data);
            }
            catch (IOException iOException) {
                iOException.printStackTrace();
            }
        } else {
            System.err.println("Invalid Wave Header");
        }
    }

    public void trim(int n, int n2) {
        long l = this.waveHeader.getChunkSize();
        long l2 = n + n2;
        long l3 = this.waveHeader.getSubChunk2Size();
        if (l2 > l3) {
            n = (int)l3;
        }
        if ((l -= l2) >= 0L && (l3 -= l2) >= 0L) {
            this.waveHeader.setChunkSize(l);
            this.waveHeader.setSubChunk2Size(l3);
            byte[] byArray = new byte[(int)l3];
            System.arraycopy(this.data, n, byArray, 0, (int)l3);
            this.data = byArray;
        } else {
            System.err.println("Trim error: Negative length");
        }
    }

    public void leftTrim(int n) {
        this.trim(n, 0);
    }

    public void rightTrim(int n) {
        this.trim(0, n);
    }

    public void trim(double d, double d2) {
        int n = this.waveHeader.getSampleRate();
        int n2 = this.waveHeader.getBitsPerSample();
        int n3 = this.waveHeader.getChannels();
        int n4 = (int)((double)(n * n2 / 8 * n3) * d);
        int n5 = (int)((double)(n * n2 / 8 * n3) * d2);
        this.trim(n4, n5);
    }

    public void leftTrim(double d) {
        this.trim(d, 0.0);
    }

    public void rightTrim(double d) {
        this.trim(0.0, d);
    }

    public WaveHeader getWaveHeader() {
        return this.waveHeader;
    }

    public Spectrogram getSpectrogram() {
        return new Spectrogram(this);
    }

    public Spectrogram getSpectrogram(int n, int n2) {
        return new Spectrogram(this, n, n2);
    }

    public byte[] getBytes() {
        return this.data;
    }

    public int size() {
        return this.data.length;
    }

    public float length() {
        float f = (float)this.waveHeader.getSubChunk2Size() / (float)this.waveHeader.getByteRate();
        return f;
    }

    public String timestamp() {
        float f = this.length();
        float f2 = f % 60.0f;
        int n = (int)f / 60 % 60;
        int n2 = (int)(f / 3600.0f);
        StringBuffer stringBuffer = new StringBuffer();
        if (n2 > 0) {
            stringBuffer.append(n2 + ":");
        }
        if (n > 0) {
            stringBuffer.append(n + ":");
        }
        stringBuffer.append(f2);
        return stringBuffer.toString();
    }

    public short[] getSampleAmplitudes() {
        int n = this.waveHeader.getBitsPerSample() / 8;
        int n2 = this.data.length / n;
        short[] sArray = new short[n2];
        int n3 = 0;
        for (int i = 0; i < n2; ++i) {
            short s = 0;
            for (int j = 0; j < n; ++j) {
                s = (short)(s | (short)((this.data[n3++] & 0xFF) << j * 8));
            }
            sArray[i] = s;
        }
        return sArray;
    }

    public String toString() {
        StringBuffer stringBuffer = new StringBuffer(this.waveHeader.toString());
        stringBuffer.append("\n");
        stringBuffer.append("length: " + this.timestamp());
        return stringBuffer.toString();
    }

    public double[] getNormalizedAmplitudes() {
        NormalizedSampleAmplitudes normalizedSampleAmplitudes = new NormalizedSampleAmplitudes(this);
        return normalizedSampleAmplitudes.getNormalizedAmplitudes();
    }

    public byte[] getFingerprint() {
        if (this.fingerprint == null) {
            FingerprintManager fingerprintManager = new FingerprintManager();
            this.fingerprint = fingerprintManager.extractFingerprint(this);
        }
        return this.fingerprint;
    }

    public FingerprintSimilarity getFingerprintSimilarity(Wave wave) {
        FingerprintSimilarityComputer fingerprintSimilarityComputer = new FingerprintSimilarityComputer(this.getFingerprint(), wave.getFingerprint());
        return fingerprintSimilarityComputer.getFingerprintsSimilarity();
    }
}

