/*
 * Decompiled with CFR 0.152.
 */
package sound.musicg.wave;

import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import sound.musicg.wave.Wave;
import sound.musicg.wave.WaveHeader;

public class WaveFileManager {
    private Wave wave;

    public WaveFileManager() {
        this.wave = new Wave();
    }

    public WaveFileManager(Wave wave) {
        this.setWave(wave);
    }

    public void saveWaveAsFile(String string) {
        WaveHeader waveHeader = this.wave.getWaveHeader();
        int n = waveHeader.getByteRate();
        int n2 = waveHeader.getAudioFormat();
        int n3 = waveHeader.getSampleRate();
        int n4 = waveHeader.getBitsPerSample();
        int n5 = waveHeader.getChannels();
        long l = waveHeader.getChunkSize();
        long l2 = waveHeader.getSubChunk1Size();
        long l3 = waveHeader.getSubChunk2Size();
        int n6 = waveHeader.getBlockAlign();
        try {
            FileOutputStream fileOutputStream = new FileOutputStream(string);
            fileOutputStream.write("RIFF".getBytes());
            fileOutputStream.write(new byte[]{(byte)l, (byte)(l >> 8), (byte)(l >> 16), (byte)(l >> 24)});
            fileOutputStream.write("WAVE".getBytes());
            fileOutputStream.write("fmt ".getBytes());
            fileOutputStream.write(new byte[]{(byte)l2, (byte)(l2 >> 8), (byte)(l2 >> 16), (byte)(l2 >> 24)});
            fileOutputStream.write(new byte[]{(byte)n2, (byte)(n2 >> 8)});
            fileOutputStream.write(new byte[]{(byte)n5, (byte)(n5 >> 8)});
            fileOutputStream.write(new byte[]{(byte)n3, (byte)(n3 >> 8), (byte)(n3 >> 16), (byte)(n3 >> 24)});
            fileOutputStream.write(new byte[]{(byte)n, (byte)(n >> 8), (byte)(n >> 16), (byte)(n >> 24)});
            fileOutputStream.write(new byte[]{(byte)n6, (byte)(n6 >> 8)});
            fileOutputStream.write(new byte[]{(byte)n4, (byte)(n4 >> 8)});
            fileOutputStream.write("data".getBytes());
            fileOutputStream.write(new byte[]{(byte)l3, (byte)(l3 >> 8), (byte)(l3 >> 16), (byte)(l3 >> 24)});
            fileOutputStream.write(this.wave.getBytes());
            fileOutputStream.close();
        }
        catch (FileNotFoundException fileNotFoundException) {
            fileNotFoundException.printStackTrace();
        }
        catch (IOException iOException) {
            iOException.printStackTrace();
        }
    }

    public Wave getWave() {
        return this.wave;
    }

    public void setWave(Wave wave) {
        this.wave = wave;
    }
}

