/*
 * Decompiled with CFR 0.152.
 */
package sound.musicg.wave.extension;

import sound.musicg.wave.Wave;

public class NormalizedSampleAmplitudes {
    private Wave wave;
    private double[] normalizedAmplitudes;

    public NormalizedSampleAmplitudes(Wave wave) {
        this.wave = wave;
    }

    public double[] getNormalizedAmplitudes() {
        if (this.normalizedAmplitudes == null) {
            boolean bl = true;
            if (this.wave.getWaveHeader().getBitsPerSample() == 8) {
                bl = false;
            }
            short[] sArray = this.wave.getSampleAmplitudes();
            int n = sArray.length;
            int n2 = 1 << this.wave.getWaveHeader().getBitsPerSample() - 1;
            if (!bl) {
                n2 <<= 1;
            }
            this.normalizedAmplitudes = new double[n];
            for (int i = 0; i < n; ++i) {
                this.normalizedAmplitudes[i] = (double)sArray[i] / (double)n2;
            }
        }
        return this.normalizedAmplitudes;
    }
}

