/*
 * Decompiled with CFR 0.152.
 */
package sound.paulscode;

import sound.paulscode.SimpleThread;
import sound.paulscode.SoundSystem;
import sound.paulscode.SoundSystemConfig;
import sound.paulscode.SoundSystemLogger;

public class CommandThread
extends SimpleThread {
    protected SoundSystemLogger logger = SoundSystemConfig.getLogger();
    private SoundSystem soundSystem;
    protected String className = "CommandThread";

    public CommandThread(SoundSystem soundSystem) {
        this.soundSystem = soundSystem;
    }

    @Override
    protected void cleanup() {
        this.kill();
        this.logger = null;
        this.soundSystem = null;
        super.cleanup();
    }

    @Override
    public void run() {
        long l;
        long l2 = l = System.currentTimeMillis();
        if (this.soundSystem == null) {
            this.errorMessage("SoundSystem was null in method run().", 0);
            this.cleanup();
            return;
        }
        this.snooze(3600000L);
        while (!this.dying()) {
            this.soundSystem.ManageSources();
            this.soundSystem.CommandQueue(null);
            l2 = System.currentTimeMillis();
            if (!this.dying() && l2 - l > 10000L) {
                l = l2;
                this.soundSystem.removeTemporarySources();
            }
            if (this.dying()) continue;
            this.snooze(3600000L);
        }
        this.cleanup();
    }

    protected void message(String string, int n) {
        this.logger.message(string, n);
    }

    protected void importantMessage(String string, int n) {
        this.logger.importantMessage(string, n);
    }

    protected boolean errorCheck(boolean bl, String string) {
        return this.logger.errorCheck(bl, this.className, string, 0);
    }

    protected void errorMessage(String string, int n) {
        this.logger.errorMessage(this.className, string, n);
    }
}

