/*
 * Decompiled with CFR 0.152.
 */
package br.com.etyllica.animation.pivot;

import br.com.etyllica.animation.pivot.PivotPoint;
import br.com.etyllica.core.graphics.Graphic;
import br.com.etyllica.core.loader.image.ImageLoader;
import br.com.etyllica.layer.PivotImageLayer;
import java.awt.Color;
import java.awt.Image;
import java.awt.geom.AffineTransform;
import java.awt.image.ImageObserver;
import java.util.ArrayList;
import java.util.List;

public class Part
extends PivotImageLayer {
    protected List<PivotPoint> points = new ArrayList<PivotPoint>();
    private Color borderColor = Color.BLUE;

    public Part(int n, int n2) {
        super(n, n2);
    }

    public Part(int n, int n2, String string) {
        super(n, n2, string);
    }

    public Part(String string) {
        super(0, 0, string);
    }

    public void addPoint(PivotPoint pivotPoint) {
        this.addPoint((int)pivotPoint.getX(), (int)pivotPoint.getY());
    }

    public void addPoint(int n, int n2) {
        this.points.add(new PivotPoint(this.x + n, this.y + n2));
    }

    public void rotate(double d) {
        double d2 = d - this.angle;
        for (PivotPoint pivotPoint : this.points) {
            double d3 = this.x + this.xPivot;
            double d4 = this.y + this.yPivot;
            pivotPoint.rotate(d3, d4, d2);
        }
        this.setAngle(d);
    }

    public void rotateByParent(double d) {
        for (PivotPoint pivotPoint : this.points) {
            double d2 = this.x + this.xPivot;
            double d3 = this.y + this.yPivot;
            pivotPoint.rotate(d2, d3, d);
        }
        this.setOffsetAngle(d);
    }

    @Override
    public AffineTransform getTransform() {
        return AffineTransform.getRotateInstance(Math.toRadians(this.angle), this.x + this.xPivot, this.y + this.yPivot);
    }

    @Override
    public void draw(Graphic graphic) {
        if (this.visible) {
            AffineTransform affineTransform = graphic.getTransform();
            graphic.setTransform(this.getTransform());
            graphic.drawImage((Image)ImageLoader.getInstance().getImage(this.path), this.x, this.y, this.x + this.w, this.y + this.h, this.xImage, this.yImage, this.xImage + this.w, this.yImage + this.h, (ImageObserver)null);
            graphic.setTransform(affineTransform);
        }
    }

    @Override
    public void setOffsetX(int n) {
        this.x += n;
        for (PivotPoint pivotPoint : this.points) {
            pivotPoint.setX(pivotPoint.getX() + (double)n);
        }
    }

    @Override
    public void setOffsetY(int n) {
        this.y += n;
        for (PivotPoint pivotPoint : this.points) {
            pivotPoint.setY(pivotPoint.getY() + (double)n);
        }
    }

    public Color getBorderColor() {
        return this.borderColor;
    }

    public void setBorderColor(Color color) {
        this.borderColor = color;
    }

    public List<PivotPoint> getPoints() {
        return this.points;
    }

    public void setPontos(List<PivotPoint> list) {
        this.points = list;
    }
}

