/*
 * Decompiled with CFR 0.152.
 */
package br.com.etyllica.animation.scripts;

import br.com.etyllica.animation.listener.OnAnimationFinishListener;

public abstract class AnimationScript {
    protected long startedAt = 0L;
    protected long time = 0L;
    protected long delay = 0L;
    protected int repeat = 0;
    private boolean started = false;
    private boolean stopped = false;
    protected long endDelay = 0L;
    private AnimationScript next;
    public static final int REPEAT_FOREVER = -1;
    private OnAnimationFinishListener listener;

    public AnimationScript(long l) {
        this.time = l;
    }

    public AnimationScript(long l, long l2) {
        this.delay = l;
        this.time = l2;
    }

    public void restart() {
        this.started = false;
        this.stopped = false;
    }

    public void start(long l) {
        this.startedAt = l;
    }

    public void preAnimate(long l) {
        if (!this.started) {
            this.started = true;
            this.stopped = false;
            this.startedAt = l;
        }
        if (this.started && !this.stopped) {
            long l2 = l - this.startedAt - this.delay;
            if (l2 >= this.time) {
                if (l2 >= this.time + this.endDelay) {
                    this.stopped = true;
                }
            } else if (l - this.startedAt >= this.delay) {
                this.animate(l);
            }
        }
    }

    public void animate(long l) {
        long l2 = l - this.startedAt - this.delay;
        float f = (float)l2 / (float)this.time;
        this.calculate(f);
    }

    public abstract void calculate(double var1);

    public boolean isStopped() {
        return this.stopped;
    }

    public int getRepeat() {
        return this.repeat;
    }

    public void setRepeat(int n) {
        this.repeat = n;
    }

    public AnimationScript getNext() {
        return this.next;
    }

    public void setNext(AnimationScript animationScript) {
        this.next = animationScript;
    }

    public long getDelay() {
        return this.delay;
    }

    public void setDelay(long l) {
        this.delay = l;
    }

    public void setEndDelay(long l) {
        this.endDelay = l;
    }

    public OnAnimationFinishListener getListener() {
        return this.listener;
    }

    public void setListener(OnAnimationFinishListener onAnimationFinishListener) {
        this.listener = onAnimationFinishListener;
    }
}

