/*
 * Decompiled with CFR 0.152.
 */
package br.com.etyllica.collision;

import br.com.etyllica.layer.GeometricLayer;
import br.com.etyllica.layer.Layer;
import br.com.etyllica.linear.Point2D;

public class CollisionDetector {
    public static boolean colideCirclePoint(float f, float f2, float f3, int n, int n2) {
        float f4 = f - (float)n;
        float f5 = f2 - (float)n2;
        return f4 * f4 + f5 * f5 < f3 * f3;
    }

    public static boolean colideIsometricPoint(Layer layer, int n, int n2) {
        float f = layer.getH() / 2;
        float f2 = layer.getW() / 2;
        float f3 = n - layer.getX();
        float f4 = n2 - layer.getY();
        if (f4 > f) {
            f4 = f - (f4 - f);
        }
        return !(f3 > f2 + 1.0f + 2.0f * f4) && !(f3 < f2 - 1.0f - 2.0f * f4);
    }

    public static boolean colideHexagonPoint(Layer layer, int n, int n2) {
        float f = layer.getH() / 2;
        float f2 = layer.getW() / 4;
        float f3 = n - layer.getX();
        float f4 = n2 - layer.getY();
        if (f3 > f2 * 3.0f) {
            f3 = f2 - (f3 - f2 * 3.0f);
        } else if (f3 > f2) {
            return n2 >= layer.getY() && n2 <= layer.getY() + layer.getH();
        }
        return !(f4 > f + 1.0f + 2.0f * f3) && !(f4 < f - 1.0f - 2.0f * f3);
    }

    public static boolean colideRectPoint(GeometricLayer geometricLayer, double d, double d2) {
        int n = geometricLayer.utilWidth();
        int n2 = geometricLayer.utilHeight();
        int n3 = geometricLayer.getX() + n / 2;
        int n4 = geometricLayer.getY() + n2 / 2;
        return Math.abs((double)n3 - d) <= (double)(n / 2) && Math.abs((double)n4 - d2) <= (double)(n2 / 2);
    }

    public static boolean colideRectPoint(Layer layer, double d, double d2) {
        int n = layer.getX() + layer.getW() / 2;
        int n2 = layer.getY() + layer.getH() / 2;
        int n3 = layer.getW();
        int n4 = layer.getH();
        double d3 = Math.toRadians(-layer.getAngle());
        return CollisionDetector.testRectangleToPoint(n3, n4, d3, n, n2, d, d2);
    }

    public static boolean colideRectPoint(Layer layer, double d, double d2, double d3, double d4) {
        int n = (int)((double)layer.getW() * d3);
        int n2 = (int)((double)layer.getH() * d4);
        int n3 = layer.getX() + n / 2 - (int)((double)layer.getW() / d3);
        int n4 = layer.getY() + n2 / 2 - (int)((double)layer.getH() / d4);
        int n5 = n;
        int n6 = n2;
        double d5 = Math.toRadians(-layer.getAngle());
        return CollisionDetector.testRectangleToPoint(n5, n6, d5, n3, n4, d, d2);
    }

    public static boolean colideRectPoint(Layer layer, Point2D point2D) {
        int n = layer.getX() + layer.getW() / 2;
        int n2 = layer.getY() + layer.getH() / 2;
        int n3 = layer.getW();
        int n4 = layer.getH();
        double d = Math.toRadians(-layer.getAngle());
        return CollisionDetector.testRectangleToPoint(n3, n4, d, n, n2, point2D.getX(), point2D.getY());
    }

    private static boolean testRectangleToPoint(double d, double d2, double d3, double d4, double d5, double d6, double d7) {
        if (d3 == 0.0) {
            return Math.abs(d4 - d6) < d / 2.0 && Math.abs(d5 - d7) < d2 / 2.0;
        }
        double d8 = Math.cos(d3);
        double d9 = Math.cos(d3);
        double d10 = d8 * d6 - d9 * d7;
        double d11 = d8 * d7 + d9 * d6;
        double d12 = d8 * d4 - d9 * d5;
        double d13 = d8 * d5 + d9 * d4;
        return Math.abs(d12 - d10) < d / 2.0 && Math.abs(d13 - d11) < d2 / 2.0;
    }

    private static boolean testCircleToSegment(double d, double d2, double d3, double d4, double d5, double d6, double d7) {
        double d8;
        double d9 = Math.sqrt(Math.pow(d4 - d6, 2.0) + Math.pow(d5 - d7, 2.0));
        if (d9 == 0.0) {
            double d10 = Math.sqrt(Math.pow(d - d4, 2.0) + Math.pow(d2 - d5, 2.0));
            return d10 < d3;
        }
        double d11 = ((d - d4) * (d6 - d4) + (d2 - d5) * (d7 - d5)) / (d9 * d9);
        if (d11 < 0.0) {
            d8 = Math.sqrt(Math.pow(d - d4, 2.0) + Math.pow(d2 - d5, 2.0));
        } else if (d11 > 1.0) {
            d8 = Math.sqrt(Math.pow(d - d6, 2.0) + Math.pow(d2 - d7, 2.0));
        } else {
            double d12 = d4 + d11 * (d6 - d4);
            double d13 = d5 + d11 * (d7 - d5);
            d8 = Math.sqrt(Math.pow(d - d12, 2.0) + Math.pow(d2 - d13, 2.0));
        }
        return d8 < d3;
    }

    public static boolean testRectangleToCircle(double d, double d2, double d3, double d4, double d5, double d6, double d7, double d8) {
        double d9;
        double d10;
        double d11;
        double d12;
        if (d3 == 0.0) {
            d12 = d6;
            d11 = d7;
            d10 = d4;
            d9 = d5;
        } else {
            d12 = Math.cos(d3) * d6 - Math.sin(d3) * d7;
            d11 = Math.cos(d3) * d7 + Math.sin(d3) * d6;
            d10 = Math.cos(d3) * d4 - Math.sin(d3) * d5;
            d9 = Math.cos(d3) * d5 + Math.sin(d3) * d4;
        }
        return CollisionDetector.testRectangleToPoint(d, d2, d3, d4, d5, d6, d7) || CollisionDetector.testCircleToSegment(d12, d11, d8, d10 - d / 2.0, d9 + d2 / 2.0, d10 + d / 2.0, d9 + d2 / 2.0) || CollisionDetector.testCircleToSegment(d12, d11, d8, d10 + d / 2.0, d9 + d2 / 2.0, d10 + d / 2.0, d9 - d2 / 2.0) || CollisionDetector.testCircleToSegment(d12, d11, d8, d10 + d / 2.0, d9 - d2 / 2.0, d10 - d / 2.0, d9 - d2 / 2.0) || CollisionDetector.testCircleToSegment(d12, d11, d8, d10 - d / 2.0, d9 - d2 / 2.0, d10 - d / 2.0, d9 + d2 / 2.0);
    }

    public static boolean colideRectRect(Layer layer, Layer layer2) {
        if (layer.getAngle() == 0.0 && layer2.getAngle() == 0.0) {
            if (layer2.getX() + layer2.getW() < layer.getX()) {
                return false;
            }
            if (layer2.getX() > layer.getX() + layer.getW()) {
                return false;
            }
            if (layer2.getY() + layer2.getH() < layer.getY()) {
                return false;
            }
            return layer2.getY() <= layer.getY() + layer.getH();
        }
        return CollisionDetector.colidePolygon(layer, layer2);
    }

    public static boolean colidePolygon(Layer layer, Layer layer2) {
        Point2D[] point2DArray = CollisionDetector.getBounds(layer);
        Point2D[] point2DArray2 = CollisionDetector.getBounds(layer2);
        return CollisionDetector.colidePoints(point2DArray, point2DArray2);
    }

    public static Point2D[] getBounds(Layer layer) {
        Point2D[] point2DArray = new Point2D[]{new Point2D(layer.getX(), layer.getY()), new Point2D(layer.getX() + layer.getW(), layer.getY()), new Point2D(layer.getX() + layer.getW(), layer.getY() + layer.getH()), new Point2D(layer.getX(), layer.getY() + layer.getH())};
        if (layer.getAngle() != 0.0) {
            for (Point2D point2D : point2DArray) {
                point2D.rotate(layer.getX() + layer.getW() / 2, layer.getY() + layer.getH() / 2, layer.getAngle());
            }
        }
        return point2DArray;
    }

    private static double[] e2p(double d, double d2) {
        return new double[]{d, d2, 1.0};
    }

    private static double[] getCrossProduct(double[] dArray, double[] dArray2) {
        return new double[]{dArray[1] * dArray2[2] - dArray[2] * dArray2[1], dArray[2] * dArray2[0] - dArray[0] * dArray2[2], dArray[0] * dArray2[1] - dArray[1] * dArray2[0]};
    }

    private static double getDotProduct(double[] dArray, double[] dArray2) {
        return dArray[0] * dArray2[0] + dArray[1] * dArray2[1] + dArray[2] * dArray2[2];
    }

    public static boolean colidePoints(Point2D[] point2DArray, Point2D[] point2DArray2) {
        return !CollisionDetector.isSeparate(point2DArray, point2DArray2) && !CollisionDetector.isSeparate(point2DArray2, point2DArray);
    }

    private static boolean isSeparate(Point2D[] point2DArray, Point2D[] point2DArray2) {
        block0: for (int i = 0; i < point2DArray.length; ++i) {
            double[] dArray = CollisionDetector.e2p(point2DArray[i].getX(), point2DArray[i].getY());
            int n = i + 1 < point2DArray.length ? i + 1 : 0;
            double[] dArray2 = CollisionDetector.e2p(point2DArray[n].getX(), point2DArray[n].getY());
            double[] dArray3 = CollisionDetector.getCrossProduct(dArray, dArray2);
            for (Point2D point2D : point2DArray2) {
                double d = CollisionDetector.getDotProduct(dArray3, CollisionDetector.e2p(point2D.getX(), point2D.getY()));
                if (d > -0.001) continue block0;
            }
            return true;
        }
        return false;
    }
}

