/*
 * Decompiled with CFR 0.152.
 */
package br.com.etyllica.context;

import br.com.etyllica.cinematics.Camera;
import br.com.etyllica.context.Scene;
import br.com.etyllica.context.Session;
import br.com.etyllica.context.load.DefaultLoadApplication;
import br.com.etyllica.context.load.LoadListener;
import br.com.etyllica.core.Updatable;
import br.com.etyllica.core.event.GUIEvent;
import br.com.etyllica.core.graphics.Graphic;
import br.com.etyllica.core.input.mouse.MouseState;
import br.com.etyllica.core.input.mouse.MouseStateChanger;
import br.com.etyllica.core.input.mouse.MouseStateListener;
import br.com.etyllica.effects.TransitionEffect;
import br.com.etyllica.gui.View;
import br.com.etyllica.i18n.Language;
import br.com.etyllica.i18n.LanguageChanger;
import br.com.etyllica.i18n.LanguageChangerListener;

public abstract class Context
extends View
implements Updatable,
MouseStateChanger,
LanguageChanger {
    private int updateInterval = 0;
    protected TransitionEffect effect = TransitionEffect.NONE;
    protected float loading = 0.0f;
    protected String loadingInfo = "Carregando...";
    protected String title = "Application";
    protected boolean clearBeforeDraw = true;
    protected Session session;
    protected Camera camera;
    protected Scene scene = new Scene();
    protected long lastUpdate = 0L;
    private boolean locked = false;
    protected boolean paused = false;
    private LoadListener loadListener;
    private MouseStateListener mouseStateListener;
    private LanguageChangerListener languageChangerListener;
    protected Context nextApplication = this;
    protected DefaultLoadApplication loadApplication;
    protected int fps = 0;

    public Context(int n, int n2, int n3, int n4) {
        super(n, n2, n3, n4);
    }

    public Context(int n, int n2) {
        this(0, 0, n, n2);
    }

    public void startLoad() {
        this.locked = true;
        this.loading = 0.0f;
        this.load();
        this.locked = false;
        this.notifyListeners();
    }

    private void notifyListeners() {
        this.loadListener.loaded();
    }

    public abstract void load();

    @Override
    public abstract void draw(Graphic var1);

    public void unload() {
    }

    @Override
    public void update(GUIEvent gUIEvent) {
    }

    @Override
    public void update(long l) {
    }

    @Override
    public boolean onMouse(int n, int n2) {
        return false;
    }

    public float getLoading() {
        return this.loading;
    }

    public String getLoadingInfo() {
        return this.loadingInfo;
    }

    public void setSession(Session session) {
        this.session = session;
    }

    public Session getSession() {
        return this.session;
    }

    public void setSessionValue(String string, Object object) {
        this.session.put(string, object);
    }

    public Object getSessionValue(String string) {
        return this.session.get(string);
    }

    public boolean isClearBeforeDraw() {
        return this.clearBeforeDraw;
    }

    public void setClearBeforeDraw(boolean bl) {
        this.clearBeforeDraw = bl;
    }

    public String getTitle() {
        return this.title;
    }

    public void setTitle(String string) {
        this.title = string;
    }

    protected void updateAtFixedRate(int n) {
        this.updateInterval = n;
    }

    protected void stopTimeUpdate() {
        this.updateInterval = 0;
    }

    public void timeUpdate(long l) {
    }

    @Override
    public void changeMouseState(MouseState mouseState) {
        if (this.mouseStateListener != null) {
            this.mouseStateListener.changeState(mouseState);
        }
    }

    public MouseStateListener getMouseStateListener() {
        return this.mouseStateListener;
    }

    public void setMouseStateListener(MouseStateListener mouseStateListener) {
        this.mouseStateListener = mouseStateListener;
    }

    @Override
    public void changeLanguage(Language language) {
        if (this.languageChangerListener != null) {
            this.languageChangerListener.changeLanguage(language);
        }
    }

    public LanguageChangerListener getLanguageChangerListener() {
        return this.languageChangerListener;
    }

    public void setLanguageChangerListener(LanguageChangerListener languageChangerListener) {
        this.languageChangerListener = languageChangerListener;
    }

    public int getUpdateInterval() {
        return this.updateInterval;
    }

    public long getLastUpdate() {
        return this.lastUpdate;
    }

    public void setLastUpdate(long l) {
        this.lastUpdate = l;
    }

    public boolean isLocked() {
        return this.locked;
    }

    public void setLoadListener(LoadListener loadListener) {
        this.loadListener = loadListener;
    }

    public Context getNextApplication() {
        return this.nextApplication;
    }

    protected void setNextApplication(Context context) {
        this.nextApplication = context;
    }

    public Scene getScene() {
        return this.scene;
    }

    public void setScene(Scene scene) {
        this.scene = scene;
    }

    public Camera getCamera() {
        return this.camera;
    }

    public void setCamera(Camera camera) {
        this.camera = camera;
    }

    public int getFps() {
        return this.fps;
    }

    public void setFps(int n) {
        this.fps = n;
    }

    public DefaultLoadApplication getLoadApplication() {
        return this.loadApplication;
    }
}

