/*
 * Decompiled with CFR 0.152.
 */
package br.com.etyllica.context.load;

import br.com.etyllica.context.Context;
import br.com.etyllica.context.load.LoadApplication;
import br.com.etyllica.context.load.LoadListener;
import br.com.etyllica.gui.Window;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.Executors;
import java.util.concurrent.Future;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.TimeUnit;

public class ApplicationLoader
implements LoadListener {
    private Loader loader;
    private Updater updater;
    private Window window;
    private Context application;
    private LoadApplication loadApplication;
    private boolean called = false;
    private ScheduledExecutorService loadExecutor;
    private Future<?> future;
    private static final int UPDATE_INTERVAL = 10;
    private String lastText = "";
    private float lastLoading = 0.0f;

    public void loadApplication() {
        this.lastText = "";
        this.lastLoading = 0.0f;
        this.loadExecutor = Executors.newScheduledThreadPool(2);
        this.window.setLoaded(false);
        this.loader = new Loader();
        this.updater = new Updater();
        this.future = this.loadExecutor.submit(this.loader);
        this.loadExecutor.scheduleAtFixedRate(this.updater, 0L, 10L, TimeUnit.MILLISECONDS);
    }

    private void notifyTextChanged() {
        String string = this.application.getLoadingInfo();
        if (!this.lastText.equals(string)) {
            this.lastText = string;
            this.loadApplication.onChangeText(string);
        }
    }

    private void notifyLoadingChanged() {
        float f = this.application.getLoading();
        if (this.lastLoading != f) {
            this.lastLoading = f;
            this.loadApplication.onChangeLoad(f);
        }
    }

    public Context getApplication() {
        return this.application;
    }

    public void setApplication(Context context) {
        this.application = context;
    }

    public LoadApplication getLoadApplication() {
        return this.loadApplication;
    }

    public void setLoadApplication(LoadApplication loadApplication) {
        this.loadApplication = loadApplication;
    }

    public Window getWindow() {
        return this.window;
    }

    public void setWindow(Window window) {
        this.window = window;
    }

    @Override
    public void loaded() {
        this.called = true;
    }

    private class Updater
    implements Runnable {
        private Updater() {
        }

        @Override
        public void run() {
            if (!ApplicationLoader.this.called) {
                if (!ApplicationLoader.this.window.isLoaded()) {
                    ApplicationLoader.this.notifyTextChanged();
                    ApplicationLoader.this.notifyLoadingChanged();
                }
            } else {
                try {
                    ApplicationLoader.this.future.get();
                }
                catch (ExecutionException executionException) {
                    Throwable throwable = executionException.getCause();
                    throwable.printStackTrace();
                }
                catch (InterruptedException interruptedException) {
                    interruptedException.printStackTrace();
                }
                ApplicationLoader.this.window.setApplication(ApplicationLoader.this.application);
                ApplicationLoader.this.window.setLoaded(true);
                ApplicationLoader.this.loadExecutor.shutdownNow();
            }
        }
    }

    private class Loader
    implements Runnable {
        private Loader() {
        }

        @Override
        public void run() {
            ApplicationLoader.this.called = false;
            ApplicationLoader.this.application.setLoadListener(ApplicationLoader.this);
            ApplicationLoader.this.application.startLoad();
        }
    }
}

