/*
 * Decompiled with CFR 0.152.
 */
package br.com.etyllica.core.graphics;

import br.com.etyllica.cinematics.Camera;
import br.com.etyllica.layer.GeometricLayer;
import br.com.etyllica.layer.Layer;
import br.com.etyllica.linear.Point2D;
import java.awt.AlphaComposite;
import java.awt.BasicStroke;
import java.awt.Color;
import java.awt.Font;
import java.awt.FontMetrics;
import java.awt.Graphics2D;
import java.awt.Image;
import java.awt.Paint;
import java.awt.Polygon;
import java.awt.RenderingHints;
import java.awt.Shape;
import java.awt.Stroke;
import java.awt.font.FontRenderContext;
import java.awt.font.TextLayout;
import java.awt.geom.AffineTransform;
import java.awt.image.BufferedImage;
import java.awt.image.ImageObserver;
import java.awt.image.VolatileImage;

public class Graphic {
    private VolatileImage vimg;
    protected Graphics2D screen;
    private int width;
    private int height;
    private Color shadowColor = Color.BLACK;
    private static final AffineTransform RESET_TRANSFORM = AffineTransform.getScaleInstance(1.0, 1.0);

    public Graphic(int n, int n2) {
        this.width = n;
        this.height = n2;
    }

    public Graphic(BufferedImage bufferedImage) {
        this.setImage(bufferedImage);
    }

    public void setFastImage(BufferedImage bufferedImage) {
        this.screen = (Graphics2D)bufferedImage.getGraphics();
        if (this.screen == null) {
            this.screen = bufferedImage.createGraphics();
        }
        this.width = bufferedImage.getWidth();
        this.height = bufferedImage.getHeight();
    }

    public void setImage(BufferedImage bufferedImage) {
        this.setFastImage(bufferedImage);
        this.screen.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
        this.screen.setColor(this.shadowColor);
    }

    public void setVolatileImage(VolatileImage volatileImage) {
        this.vimg = volatileImage;
        this.width = volatileImage.getWidth();
        this.height = volatileImage.getHeight();
        this.screen = volatileImage.createGraphics();
        this.screen.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
        this.screen.setColor(this.shadowColor);
    }

    public void resetImage() {
        if (this.vimg == null) {
            return;
        }
        this.screen = this.vimg.createGraphics();
        this.screen.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
        this.screen.setColor(this.shadowColor);
    }

    public void drawString(int n, int n2, int n3, int n4, String string) {
        int n5 = this.centralizeTextX(string, n, n3);
        int n6 = this.centralizeTextY(string, n2, n4);
        this.screen.drawString(string, n5, n6);
    }

    public void drawString(float f, float f2, float f3, float f4, String string) {
        this.drawString((int)f, (int)f2, (int)f3, (int)f4, string);
    }

    public void drawStringExponent(String string, String string2, int n, int n2) {
        this.drawString(string, n, n2);
        FontMetrics fontMetrics = this.screen.getFontMetrics();
        float f = fontMetrics.getFont().getSize2D();
        float f2 = f * 0.7f;
        int n3 = fontMetrics.stringWidth(string);
        this.setFontSize(f2);
        this.drawString(string2, n + n3, (int)((float)n2 - f2 * 0.5f));
        this.setFontSize(f);
    }

    public void drawStringExponentShadow(String string, String string2, int n, int n2) {
        this.drawShadow(n, n2, string);
        FontMetrics fontMetrics = this.screen.getFontMetrics();
        float f = fontMetrics.getFont().getSize2D();
        float f2 = f * 0.7f;
        int n3 = fontMetrics.stringWidth(string);
        this.setFontSize(f2);
        this.drawShadow(n + n3, (int)((float)n2 - f2 * 0.5f), string2);
        this.setFontSize(f);
    }

    public void drawStringShadow(int n, int n2, int n3, int n4, String string) {
        this.drawStringShadow(n, n2, n3, n4, string, this.shadowColor);
    }

    public void drawStringShadow(int n, int n2, int n3, int n4, String string, Color color) {
        int n5 = this.centralizeTextX(string, n, n3);
        int n6 = this.centralizeTextY(string, n2, n4);
        this.drawShadow(n5, n6, string, color);
    }

    public void drawStringShadow(float f, float f2, float f3, float f4, String string, Color color) {
        this.drawStringShadow((int)f, (int)f2, (int)f3, (int)f4, string, color);
    }

    public void writeX(float f, float f2, String string, boolean bl) {
        if (string == null || string.isEmpty()) {
            return;
        }
        FontMetrics fontMetrics = this.screen.getFontMetrics();
        Font font = this.getFont();
        float f3 = (float)this.centralizeTextX(string) + f;
        float f4 = f2 + (float)fontMetrics.getHeight();
        if (!bl) {
            this.screen.drawString(string, f3, f4);
        } else {
            FontRenderContext fontRenderContext = this.screen.getFontRenderContext();
            TextLayout textLayout = new TextLayout(string, font, fontRenderContext);
            Shape shape = textLayout.getOutline(AffineTransform.getTranslateInstance(f3, f2));
            this.screen.setStroke(new BasicStroke(2.666f));
            this.screen.setColor(this.shadowColor);
            this.screen.draw(shape);
            this.screen.setColor(Color.WHITE);
            this.screen.fill(shape);
        }
    }

    public void drawStringBorder(String string, int n, int n2, int n3, int n4) {
        int n5 = this.centralizeTextX(string, n, n3);
        int n6 = this.centralizeTextY(string, n2, n4);
        this.drawStringBorder(string, n5, n6);
    }

    public void drawStringBorder(String string, float f, float f2) {
        if (string == null || string.isEmpty()) {
            return;
        }
        Font font = this.getFont();
        FontRenderContext fontRenderContext = this.screen.getFontRenderContext();
        TextLayout textLayout = new TextLayout(string, font, fontRenderContext);
        Shape shape = textLayout.getOutline(AffineTransform.getTranslateInstance(f, f2));
        Color color = this.screen.getColor();
        this.screen.setColor(this.shadowColor);
        this.screen.draw(shape);
        this.screen.setColor(color);
        this.screen.fill(shape);
    }

    public void drawStringBorderX(String string, float f) {
        int n = this.centralizeTextX(string);
        this.drawStringBorder(string, n, f);
    }

    public void drawShadow(int n, int n2, String string) {
        this.drawShadow(n, n2, string, this.shadowColor);
    }

    public void drawShadow(float f, float f2, String string) {
        this.drawShadow(f, f2, string, this.shadowColor);
    }

    public void drawShadow(int n, int n2, String string, Color color) {
        if (string != null && !string.isEmpty()) {
            Color color2 = this.screen.getColor();
            this.screen.setColor(color);
            this.screen.drawString(string, n + 1, n2 + 1);
            this.screen.setColor(color2);
            this.screen.drawString(string, n, n2);
        }
    }

    public void drawShadow(float f, float f2, String string, Color color) {
        this.drawShadow((int)f, (int)f2, string, color);
    }

    public void drawStringShadowX(int n, String string) {
        if (string != null && !string.isEmpty()) {
            FontMetrics fontMetrics = this.screen.getFontMetrics();
            int n2 = this.centralizeTextX(string);
            int n3 = n + fontMetrics.getHeight();
            this.drawShadow(n2, n3, string);
        }
    }

    private int centralizeTextX(String string) {
        return this.centralizeTextX(string, 0, this.width);
    }

    private int centralizeTextX(String string, int n, int n2) {
        FontMetrics fontMetrics = this.screen.getFontMetrics();
        int n3 = fontMetrics.stringWidth(string);
        int n4 = n + n2 / 2 - n3 / 2;
        return n4;
    }

    private int centralizeTextY(String string) {
        return this.centralizeTextY(string, 0, this.height);
    }

    private int centralizeTextY(String string, int n, int n2) {
        FontMetrics fontMetrics = this.screen.getFontMetrics();
        int n3 = fontMetrics.getMaxAscent();
        int n4 = fontMetrics.getMaxDescent();
        int n5 = n + n2 / 2 - n4 / 2 + n3 / 2;
        return n5;
    }

    public void drawStringShadowX(float f, String string) {
        this.drawStringShadowX((int)f, string);
    }

    public void write(float f, float f2, String string) {
        if (string != null && !string.isEmpty()) {
            this.screen.drawString(string, f, f2);
        }
    }

    public void write(String string, GeometricLayer geometricLayer) {
        if (string != null && !string.isEmpty()) {
            this.drawString(geometricLayer.getX(), geometricLayer.getY(), geometricLayer.getW(), geometricLayer.getH(), string);
        }
    }

    public void writeShadow(String string, GeometricLayer geometricLayer) {
        if (string != null && !string.isEmpty()) {
            this.drawStringShadow(geometricLayer.getX(), geometricLayer.getY(), geometricLayer.getW(), geometricLayer.getH(), string);
        }
    }

    public void escreveX(int n, String string) {
        this.writeX(0.0f, n, string, false);
    }

    public void escreveX(int n, int n2, String string) {
        this.writeX(n, n2, string, false);
    }

    public void writeX(float f, String string, boolean bl) {
        this.writeX(0.0f, f, string, bl);
    }

    public void writeX(float f, String string) {
        this.writeX(0.0f, f, string, false);
    }

    public void escreveXCustom(int n, int n2, String string) {
        this.screen.drawString(string, 200, n2);
    }

    public void drawImage(Image image, int n, int n2, int n3, int n4, int n5, int n6, int n7, int n8, ImageObserver imageObserver) {
        this.screen.drawImage(image, n, n2, n3, n4, n5, n6, n7, n8, imageObserver);
    }

    public void drawImage(Image image, float f, float f2, float f3, float f4, float f5, float f6, float f7, float f8, ImageObserver imageObserver) {
        this.drawImage(image, (int)f, (int)f2, (int)f3, (int)f4, (int)f5, (int)f6, (int)f7, (int)f8, imageObserver);
    }

    public Graphics2D getGraphics() {
        return this.screen;
    }

    public void drawRect(GeometricLayer geometricLayer) {
        this.drawRect(geometricLayer.getX(), geometricLayer.getY(), geometricLayer.getW(), geometricLayer.getH());
    }

    public void drawRect(Layer layer) {
        AffineTransform affineTransform = layer.getTransform();
        if (affineTransform == null) {
            this.drawRect(layer.getX(), layer.getY(), layer.getW(), layer.getH());
        } else {
            this.setTransform(affineTransform);
            this.drawRect(layer.getX(), layer.getY(), layer.getW(), layer.getH());
            this.resetTransform();
        }
    }

    public void fillOval(GeometricLayer geometricLayer) {
        this.screen.fillOval(geometricLayer.getX(), geometricLayer.getY(), geometricLayer.getW(), geometricLayer.getH());
    }

    public void fillArc(GeometricLayer geometricLayer, int n, int n2) {
        this.screen.fillArc(geometricLayer.getX(), geometricLayer.getY(), geometricLayer.getW(), geometricLayer.getH(), n, n2);
    }

    public void setBasicStroke(float f) {
        this.screen.setStroke(new BasicStroke(f));
    }

    public AffineTransform getTransform() {
        return this.screen.getTransform();
    }

    public void setTransform(AffineTransform affineTransform) {
        if (this.screen != null) {
            this.screen.setTransform(affineTransform);
        }
    }

    public void transform(AffineTransform affineTransform) {
        if (this.screen != null) {
            this.screen.transform(affineTransform);
        }
    }

    public void resetTransform() {
        this.setTransform(RESET_TRANSFORM);
    }

    public void resetStroke() {
        this.screen.setStroke(new BasicStroke(1.0f));
    }

    public void setStroke(Stroke stroke) {
        this.screen.setStroke(stroke);
    }

    public void setFont(Font font) {
        this.screen.setFont(font);
    }

    public Font getFont() {
        return this.screen.getFont();
    }

    public FontRenderContext getFontRenderContext() {
        return this.screen.getFontRenderContext();
    }

    public void setColor(int n) {
        this.screen.setColor(new Color(n));
    }

    public void setColor(Color color) {
        this.screen.setColor(color);
    }

    public void setFontSize(float f) {
        this.screen.setFont(this.screen.getFont().deriveFont(f));
    }

    public void setAlpha(int n) {
        float f = (float)n / 100.0f;
        this.screen.setComposite(AlphaComposite.getInstance(3, f));
    }

    public void setComposite(AlphaComposite alphaComposite) {
        this.screen.setComposite(alphaComposite);
    }

    public void setClearAlpha(int n) {
        float f = (float)n / 100.0f;
        this.screen.setComposite(AlphaComposite.getInstance(1, f));
    }

    public void setOpacity(int n) {
        float f = (float)n / 255.0f;
        this.screen.setComposite(AlphaComposite.getInstance(3, f));
    }

    public void resetOpacity() {
        float f = 1.0f;
        this.screen.setComposite(AlphaComposite.getInstance(3, f));
    }

    public void drawImage(Image image, int n, int n2) {
        this.screen.drawImage(image, n, n2, null);
    }

    public void drawArc(int n, int n2, int n3, int n4, int n5, int n6) {
        this.screen.drawArc(n, n2, n3, n4, n5, n6);
    }

    public void drawArc(float f, float f2, float f3, float f4, int n, int n2) {
        this.drawArc((int)f, (int)f2, (int)f3, (int)f4, n, n2);
    }

    public void drawLine(int n, int n2, int n3, int n4) {
        this.screen.drawLine(n, n2, n3, n4);
    }

    public void drawLine(float f, float f2, float f3, float f4) {
        this.drawLine((int)f, (int)f2, (int)f3, (int)f4);
    }

    public void drawLine(Point2D point2D, Point2D point2D2) {
        this.screen.drawLine((int)point2D.getX(), (int)point2D.getY(), (int)point2D2.getX(), (int)point2D2.getY());
    }

    public void drawPolygon(Polygon polygon) {
        this.screen.drawPolygon(polygon);
    }

    public void fillPolygon(Polygon polygon) {
        this.screen.fillPolygon(polygon);
    }

    public void fillRect(GeometricLayer geometricLayer) {
        this.fillRect(geometricLayer.getX(), geometricLayer.getY(), geometricLayer.getW(), geometricLayer.getH());
    }

    public void fillRect(Layer layer) {
        AffineTransform affineTransform = layer.getTransform();
        if (affineTransform == null) {
            this.fillRect(layer.getX(), layer.getY(), layer.getW(), layer.getH());
        } else {
            this.setTransform(affineTransform);
            this.fillRect(layer.getX(), layer.getY(), layer.getW(), layer.getH());
            this.resetTransform();
        }
    }

    public void fillRect(int n, int n2, int n3, int n4) {
        this.screen.fillRect(n, n2, n3, n4);
    }

    public void fillRect(float f, float f2, float f3, float f4) {
        this.screen.fillRect((int)f, (int)f2, (int)f3, (int)f4);
    }

    public void fill3DRect(int n, int n2, int n3, int n4, boolean bl) {
        this.screen.fill3DRect(n, n2, n3, n4, bl);
    }

    public void fill3DRect(float f, float f2, float f3, float f4, boolean bl) {
        this.fill3DRect((int)f, (int)f2, (int)f3, (int)f4, bl);
    }

    public void fillArc(int n, int n2, int n3, int n4, int n5, int n6) {
        this.screen.fillArc(n, n2, n3, n4, n5, n6);
    }

    public void fillArc(float f, float f2, float f3, float f4, int n, int n2) {
        this.fillArc((int)f, (int)f2, (int)f3, (int)f4, n, n2);
    }

    public void drawRect(int n, int n2, int n3, int n4) {
        this.screen.drawRect(n, n2, n3, n4);
    }

    public void drawRect(double d, double d2, double d3, double d4) {
        this.screen.drawRect((int)d, (int)d2, (int)d3, (int)d4);
    }

    public void drawRoundRect(int n, int n2, int n3, int n4, int n5, int n6) {
        this.screen.drawRoundRect(n, n2, n3, n4, n5, n6);
    }

    public void fillRoundRect(int n, int n2, int n3, int n4, int n5, int n6) {
        this.screen.fillRoundRect(n, n2, n3, n4, n5, n6);
    }

    public void drawOval(int n, int n2, int n3, int n4) {
        this.screen.drawOval(n, n2, n3, n4);
    }

    public void drawOval(float f, float f2, float f3, float f4) {
        this.drawOval((int)f, (int)f2, (int)f3, (int)f4);
    }

    public void drawCircle(int n, int n2, int n3) {
        this.screen.drawOval(n - n3, n2 - n3, n3 * 2, n3 * 2);
    }

    public void drawCircle(float f, float f2, float f3) {
        this.drawCircle((int)f, (int)f2, (int)f3);
    }

    public void drawCircle(double d, double d2, double d3) {
        this.drawCircle((int)d, (int)d2, (int)d3);
    }

    public void drawCircle(Point2D point2D, int n) {
        this.screen.drawOval((int)point2D.getX() - n, (int)point2D.getY() - n, n * 2, n * 2);
    }

    public void fillCircle(int n, int n2, int n3) {
        this.screen.fillOval(n - n3, n2 - n3, n3 * 2, n3 * 2);
    }

    public void fillCircle(float f, float f2, float f3) {
        this.screen.fillOval((int)(f - f3), (int)(f2 - f3), (int)(f3 * 2.0f), (int)(f3 * 2.0f));
    }

    public void fillCircle(double d, double d2, double d3) {
        this.screen.fillOval((int)(d - d3), (int)(d2 - d3), (int)(d3 * 2.0), (int)(d3 * 2.0));
    }

    public void fillCircle(Point2D point2D, int n) {
        this.screen.fillOval((int)point2D.getX() - n, (int)point2D.getY() - n, n * 2, n * 2);
    }

    public void fillOval(int n, int n2, int n3, int n4) {
        this.screen.fillOval(n, n2, n3, n4);
    }

    public void fillOval(float f, float f2, float f3, float f4) {
        this.fillOval((int)f, (int)f2, (int)f3, (int)f4);
    }

    public void drawString(String string, int n, int n2) {
        this.screen.drawString(string, n, n2);
    }

    public void draw(Shape shape) {
        this.screen.draw(shape);
    }

    public void fill(Shape shape) {
        this.screen.fill(shape);
    }

    public FontMetrics getFontMetrics() {
        return this.screen.getFontMetrics();
    }

    public BufferedImage getBimg() {
        return this.vimg.getSnapshot();
    }

    public VolatileImage getVimg() {
        return this.vimg;
    }

    public void drawImage(BufferedImage bufferedImage, int n, int n2) {
        this.screen.drawImage((Image)bufferedImage, n, n2, null);
    }

    public void drawImage(BufferedImage bufferedImage, float f, float f2) {
        this.screen.drawImage((Image)bufferedImage, (int)f, (int)f2, null);
    }

    public void translate(int n, int n2) {
        this.screen.translate(n, n2);
    }

    public void translate(double d, double d2) {
        this.screen.translate(d, d2);
    }

    public void rotate(double d) {
        this.screen.rotate(d);
    }

    public void setBackground(Color color) {
        this.screen.setBackground(color);
    }

    public void clearRect(int n, int n2, int n3, int n4) {
        this.screen.clearRect(n, n2, n3, n4);
    }

    public void setPaint(Paint paint) {
        this.screen.setPaint(paint);
    }

    public void resetPaint() {
        this.screen.setPaint(this.screen.getColor());
    }

    public void setShadowColor(Color color) {
        this.shadowColor = color;
    }

    public void dispose() {
        this.screen.dispose();
    }

    public void setCamera(Camera camera) {
        camera.resetImage();
        this.setImage(camera.getBuffer());
    }

    public void resetCamera(Camera camera) {
        this.resetImage();
    }
}

