/*
 * Decompiled with CFR 0.152.
 */
package br.com.etyllica.core.input.joystick;

import br.com.etyllica.core.event.KeyEvent;
import br.com.etyllica.core.event.KeyState;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;

public class Joystick {
    private static final int JS_EVENT_BUTTON = 1;
    private static final int JS_EVENT_AXIS = 2;
    private static final int JS_EVENT_INIT = 128;
    public static final int MAX_AXIS_MOVEMENT = Short.MAX_VALUE;
    public static final int MIN_AXIS_MOVEMENT = -32767;
    private final String JOYSTICK_DIRECTORY = "/dev/input/js";
    private FileInputStream inputStream;
    private int id;

    public Joystick(int n) throws FileNotFoundException {
        this.id = n;
        this.inputStream = new FileInputStream("/dev/input/js" + n);
    }

    public FileInputStream getInputStream() {
        return this.inputStream;
    }

    public KeyEvent listen() {
        byte[] byArray = new byte[8];
        int n = 0;
        try {
            n = this.inputStream.read(byArray, 0, 8);
        }
        catch (IOException iOException) {
            iOException.printStackTrace();
        }
        if (n == 8) {
            long l = byArray[3] << 24 | (byArray[2] & 0xFF) << 16 | (byArray[1] & 0xFF) << 8 | byArray[0] & 0xFF;
            int n2 = byArray[5] << 8 | byArray[4] & 0xFF;
            int n3 = byArray[6] & 0xFF;
            int n4 = byArray[7] & 0xFF;
            if (n3 == 2) {
                switch (n4) {
                    case 0: 
                    case 2: {
                        if (n2 > 0) {
                            return new KeyEvent(this.id, 1051, n2, KeyState.PRESSED);
                        }
                        if (n2 < 0) {
                            return new KeyEvent(this.id, 1050, n2, KeyState.PRESSED);
                        }
                        return new KeyEvent(this.id, 1054, n2, KeyState.PRESSED);
                    }
                    case 1: 
                    case 3: {
                        if (n2 > 0) {
                            return new KeyEvent(this.id, 1053, n2, KeyState.PRESSED);
                        }
                        if (n2 < 0) {
                            return new KeyEvent(this.id, 1052, n2, KeyState.PRESSED);
                        }
                        return new KeyEvent(this.id, 1055, n2, KeyState.PRESSED);
                    }
                }
            } else if (n3 == 1) {
                int n5 = 1001 + n4;
                if (n2 == 1) {
                    return new KeyEvent(this.id, n5, 0, KeyState.PRESSED);
                }
                return new KeyEvent(this.id, n5, 0, KeyState.RELEASED);
            }
        } else {
            System.err.println("only " + n + " of 8 bytes read");
        }
        return null;
    }
}

