/*
 * Decompiled with CFR 0.152.
 */
package br.com.etyllica.core.input.keyboard;

import br.com.etyllica.core.Updatable;
import br.com.etyllica.core.event.KeyState;
import br.com.etyllica.core.input.InputKeyListener;
import br.com.etyllica.util.concurrency.ConcurrentSet;
import java.awt.event.KeyEvent;
import java.awt.event.KeyListener;
import java.lang.reflect.Field;
import java.lang.reflect.Modifier;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.CopyOnWriteArrayList;

public class Keyboard
implements KeyListener,
Updatable {
    private InputKeyListener listener;
    private List<br.com.etyllica.core.event.KeyEvent> keyEvents = new ArrayList<br.com.etyllica.core.event.KeyEvent>();
    private Map<Integer, Boolean> keys = new HashMap<Integer, Boolean>();
    private Map<Integer, KeyState> keyStates = new HashMap<Integer, KeyState>();
    private ConcurrentSet<Integer> changed = new ConcurrentSet();

    public Keyboard(InputKeyListener inputKeyListener) {
        this.listener = inputKeyListener;
    }

    @Override
    public void update(long l) {
        Set<Integer> set = this.changed.lock();
        for (Integer n : set) {
            KeyState keyState = this.keyStates.get(n);
            if (this.keys.get(n).booleanValue()) {
                if (keyState == KeyState.RELEASED) {
                    this.keyStates.put(n, KeyState.ONCE);
                    this.keyEvents.add(new br.com.etyllica.core.event.KeyEvent(n, KeyState.PRESSED));
                    continue;
                }
                if (keyState == KeyState.PRESSED) continue;
                this.keyStates.put(n, KeyState.PRESSED);
                continue;
            }
            if (keyState == KeyState.ONCE || keyState == KeyState.PRESSED) {
                this.keyStates.put(n, KeyState.FIRST_RELEASED);
                continue;
            }
            if (keyState == KeyState.FIRST_RELEASED) {
                this.keyStates.put(n, KeyState.RELEASED);
                this.keyEvents.add(new br.com.etyllica.core.event.KeyEvent(n, KeyState.RELEASED));
                this.changed.remove(n);
                continue;
            }
            if (keyState == KeyState.RELEASED) continue;
            this.keyStates.put(n, KeyState.RELEASED);
            this.changed.remove(n);
        }
        this.notifyListener();
        this.changed.unlock();
    }

    private void notifyListener() {
        CopyOnWriteArrayList<br.com.etyllica.core.event.KeyEvent> copyOnWriteArrayList = new CopyOnWriteArrayList<br.com.etyllica.core.event.KeyEvent>(this.keyEvents);
        for (br.com.etyllica.core.event.KeyEvent keyEvent : copyOnWriteArrayList) {
            this.listener.updateKeyEvent(keyEvent);
        }
        this.keyEvents.clear();
    }

    @Override
    public synchronized void keyPressed(KeyEvent keyEvent) {
        int n = this.getKeyFromEvent(keyEvent);
        this.keys.put(n, true);
        this.changed.add(n);
        keyEvent.consume();
    }

    @Override
    public synchronized void keyReleased(KeyEvent keyEvent) {
        int n = this.getKeyFromEvent(keyEvent);
        this.keys.put(n, false);
        this.changed.add(n);
        keyEvent.consume();
    }

    @Override
    public void keyTyped(KeyEvent keyEvent) {
        int n = this.getKeyFromEvent(keyEvent);
        char c = keyEvent.getKeyChar();
        if (c != '\uffff') {
            this.keyEvents.add(new br.com.etyllica.core.event.KeyEvent(n, c, KeyState.TYPED));
        }
        keyEvent.consume();
    }

    private int getKeyFromEvent(KeyEvent keyEvent) {
        int n = keyEvent.getKeyCode();
        if (keyEvent.getKeyLocation() != 1) {
            n += keyEvent.getKeyLocation() * 100;
        }
        return n;
    }

    public void reset() {
        Field[] fieldArray;
        for (Field field : fieldArray = br.com.etyllica.core.event.KeyEvent.class.getDeclaredFields()) {
            if (!Modifier.isPublic(field.getModifiers()) || !Modifier.isStatic(field.getModifiers()) || !field.getName().startsWith("TSK_")) continue;
            try {
                this.keys.put(field.getInt(null), false);
                this.keyStates.put(field.getInt(null), KeyState.RELEASED);
            }
            catch (IllegalArgumentException illegalArgumentException) {
                illegalArgumentException.printStackTrace();
            }
            catch (IllegalAccessException illegalAccessException) {
                illegalAccessException.printStackTrace();
            }
        }
    }
}

