/*
 * Decompiled with CFR 0.152.
 */
package br.com.etyllica.core.loader;

import br.com.etyllica.core.Updatable;
import br.com.etyllica.core.event.KeyEvent;
import br.com.etyllica.core.input.InputKeyListener;
import br.com.etyllica.core.input.joystick.Joystick;
import br.com.etyllica.core.loader.LoaderImpl;
import java.io.FileNotFoundException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public class JoystickLoader
extends LoaderImpl
implements Updatable,
Runnable {
    private static JoystickLoader instance = null;
    private InputKeyListener listener;
    private int joysticks = 10;
    private List<KeyEvent> joystickEvents = new ArrayList<KeyEvent>();
    private Map<Integer, Joystick> inputStreams = new HashMap<Integer, Joystick>();

    public static JoystickLoader getInstance() {
        if (instance == null) {
            instance = new JoystickLoader();
        }
        return instance;
    }

    @Override
    public void run() {
        while (true) {
            this.update(0L);
            try {
                Thread.sleep(20L);
                continue;
            }
            catch (InterruptedException interruptedException) {
                interruptedException.printStackTrace();
                continue;
            }
            break;
        }
    }

    public void init(int n) {
        this.joysticks = n;
        this.start();
        new Thread(JoystickLoader.getInstance()).start();
    }

    @Override
    public void start() {
        int n;
        for (n = 0; n < this.joysticks; ++n) {
            try {
                this.inputStreams.put(n, new Joystick(n));
                System.out.println("Joystick " + n + " found!");
                continue;
            }
            catch (FileNotFoundException fileNotFoundException) {
                System.out.println("Joystick " + n + " not found.");
                return;
            }
        }
        this.joysticks = n;
    }

    public List<KeyEvent> getJoyEvents() {
        return this.joystickEvents;
    }

    @Override
    public void update(long l) {
        for (Map.Entry<Integer, Joystick> entry : this.inputStreams.entrySet()) {
            this.listen(entry.getKey());
        }
        this.notifyListener();
    }

    private void notifyListener() {
        for (KeyEvent keyEvent : this.joystickEvents) {
            this.listener.updateJoystickEvent(keyEvent);
        }
        this.joystickEvents.clear();
    }

    private void listen(Integer n) {
        KeyEvent keyEvent = this.inputStreams.get(n).listen();
        if (keyEvent != null) {
            this.joystickEvents.add(keyEvent);
        }
    }

    public InputKeyListener getListener() {
        return this.listener;
    }

    public void setListener(InputKeyListener inputKeyListener) {
        this.listener = inputKeyListener;
    }
}

