/*
 * Decompiled with CFR 0.152.
 */
package br.com.etyllica.core.loader.image;

import br.com.etyllica.core.loader.image.ImageReaderImpl;
import java.awt.image.BufferedImage;
import java.io.ByteArrayInputStream;
import java.io.DataInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.net.URL;
import java.nio.ByteBuffer;
import java.nio.ByteOrder;
import java.util.ArrayList;
import javax.imageio.ImageIO;

public class ICOReader
extends ImageReaderImpl {
    private static final short ICO = 1;
    private static final short CUR = 2;
    private static ICOReader instance = null;

    public static ICOReader getInstance() {
        if (instance == null) {
            instance = new ICOReader();
        }
        return instance;
    }

    private void printImageType(short s) {
        if (s == 1) {
            System.out.println("imageType = ICO");
        } else if (s == 2) {
            System.out.println("imageType = CUR");
        }
    }

    @Override
    public BufferedImage loadImage(URL uRL) throws IOException {
        InputStream inputStream = uRL.openStream();
        DataInputStream dataInputStream = new DataInputStream(inputStream);
        ICOHeader iCOHeader = new ICOHeader(dataInputStream);
        ImageEntry imageEntry = new ImageEntry(dataInputStream);
        inputStream.close();
        ArrayList arrayList = new ArrayList();
        short s = 0;
        if (s < iCOHeader.images) {
            System.out.println("loading image " + s);
            ByteArrayInputStream byteArrayInputStream = new ByteArrayInputStream(imageEntry.data);
            BufferedImage bufferedImage = ImageIO.read(dataInputStream);
            return bufferedImage;
        }
        return null;
    }

    private byte[] fakeBMPHeader(int n, int n2, byte[] byArray) {
        ByteBuffer byteBuffer = ByteBuffer.allocate(54 + byArray.length);
        byteBuffer.putShort((short)19778);
        byteBuffer.putInt(byArray.length);
        byteBuffer.putShort((short)0);
        byteBuffer.putShort((short)0);
        byteBuffer.putShort((short)0);
        byteBuffer.putInt(40);
        byteBuffer.putInt(n);
        byteBuffer.putInt(n2);
        byteBuffer.putShort((short)1);
        byteBuffer.putShort((short)24);
        byteBuffer.putInt(0);
        byteBuffer.putInt(byArray.length);
        byteBuffer.putInt(0);
        byteBuffer.putInt(0);
        byteBuffer.putInt(0);
        byteBuffer.putInt(0);
        byteBuffer.put(byArray);
        return byteBuffer.array();
    }

    private class ImageEntry {
        private byte width;
        private byte height;
        private byte paletteColors;
        private byte reserved;
        private short colorPlanes;
        private short bitsPerPixel;
        private int size;
        private int offset;
        private byte[] data;

        public ImageEntry(DataInputStream dataInputStream) throws IOException {
            this.width = dataInputStream.readByte();
            System.out.println("width = " + this.width);
            this.height = dataInputStream.readByte();
            System.out.println("height = " + this.height);
            this.paletteColors = dataInputStream.readByte();
            System.out.println("paletteColors = " + this.paletteColors);
            this.reserved = dataInputStream.readByte();
            ByteBuffer byteBuffer = ByteBuffer.allocate(2);
            byteBuffer.order(ByteOrder.LITTLE_ENDIAN);
            byteBuffer.put(dataInputStream.readByte());
            byteBuffer.put(dataInputStream.readByte());
            this.colorPlanes = byteBuffer.getShort(0);
            System.out.println("colorPlanes = " + this.colorPlanes);
            ByteBuffer byteBuffer2 = ByteBuffer.allocate(2);
            byteBuffer2.order(ByteOrder.LITTLE_ENDIAN);
            byteBuffer2.put(dataInputStream.readByte());
            byteBuffer2.put(dataInputStream.readByte());
            this.bitsPerPixel = byteBuffer2.getShort(0);
            System.out.println("bitsPerPixel = " + this.bitsPerPixel);
            ByteBuffer byteBuffer3 = ByteBuffer.allocate(4);
            byteBuffer3.order(ByteOrder.LITTLE_ENDIAN);
            byteBuffer3.put(dataInputStream.readByte());
            byteBuffer3.put(dataInputStream.readByte());
            byteBuffer3.put(dataInputStream.readByte());
            byteBuffer3.put(dataInputStream.readByte());
            this.size = byteBuffer3.getInt(0);
            System.out.println("size = " + this.size);
            ByteBuffer byteBuffer4 = ByteBuffer.allocate(4);
            byteBuffer4.order(ByteOrder.LITTLE_ENDIAN);
            byteBuffer4.put(dataInputStream.readByte());
            byteBuffer4.put(dataInputStream.readByte());
            byteBuffer4.put(dataInputStream.readByte());
            byteBuffer4.put(dataInputStream.readByte());
            this.offset = byteBuffer4.getInt(0);
            System.out.println("offset = " + this.offset);
            this.data = new byte[this.size];
            dataInputStream.read(this.data);
            for (int i = 0; i < this.colorPlanes; ++i) {
            }
        }
    }

    private class ICOHeader {
        private short reserved;
        private short imageType;
        private short images;

        ICOHeader(DataInputStream dataInputStream) throws IOException {
            this.reserved = dataInputStream.readShort();
            System.out.println("Reserved = " + this.reserved);
            ByteBuffer byteBuffer = ByteBuffer.allocate(2);
            byteBuffer.order(ByteOrder.LITTLE_ENDIAN);
            byteBuffer.put(dataInputStream.readByte());
            byteBuffer.put(dataInputStream.readByte());
            this.imageType = byteBuffer.getShort(0);
            ICOReader.this.printImageType(this.imageType);
            ByteBuffer byteBuffer2 = ByteBuffer.allocate(2);
            byteBuffer2.order(ByteOrder.LITTLE_ENDIAN);
            byteBuffer2.put(dataInputStream.readByte());
            byteBuffer2.put(dataInputStream.readByte());
            this.images = byteBuffer2.getShort(0);
            System.out.println("images = " + this.images);
        }
    }
}

