/*
 * Decompiled with CFR 0.152.
 */
package br.com.etyllica.core.loader.image;

import br.com.etyllica.core.loader.LoaderImpl;
import br.com.etyllica.core.loader.image.GIFReader;
import br.com.etyllica.core.loader.image.ICOReader;
import br.com.etyllica.core.loader.image.ImageFrame;
import br.com.etyllica.core.loader.image.PCXReader;
import br.com.etyllica.core.loader.image.TGAReader;
import br.com.etyllica.layer.StaticLayer;
import java.awt.image.BufferedImage;
import java.io.IOException;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.imageio.ImageIO;

public class ImageLoader
extends LoaderImpl {
    private static ImageLoader instance = null;
    private Map<String, BufferedImage> camadas = new HashMap<String, BufferedImage>();
    private Map<String, List<ImageFrame>> animations = new HashMap<String, List<ImageFrame>>();

    private ImageLoader() {
        this.folder = "assets/images/";
    }

    public static ImageLoader getInstance() {
        if (instance == null) {
            instance = new ImageLoader();
        }
        return instance;
    }

    public StaticLayer loadImage(String string) {
        BufferedImage bufferedImage = this.getImage(string);
        StaticLayer staticLayer = new StaticLayer();
        staticLayer.setSize(bufferedImage.getWidth(), bufferedImage.getHeight());
        staticLayer.cloneLayer(string);
        return staticLayer;
    }

    public BufferedImage getImage(String string) {
        return this.getImage(string, false);
    }

    private String getDiretorio(String string, boolean bl) {
        StringBuilder stringBuilder = new StringBuilder();
        if (!bl) {
            stringBuilder.append(this.folder);
        }
        stringBuilder.append(string);
        return stringBuilder.toString();
    }

    public BufferedImage getImage(String string, boolean bl) {
        String string2 = this.getDiretorio(string, bl);
        if (this.camadas.containsKey(string2)) {
            return this.camadas.get(string2);
        }
        BufferedImage bufferedImage = null;
        URL uRL = null;
        try {
            uRL = new URL(this.url, string2);
        }
        catch (MalformedURLException malformedURLException) {
            malformedURLException.printStackTrace();
        }
        int n = string2.lastIndexOf(".");
        String string3 = string2.substring(n + 1, string2.length()).toLowerCase();
        if (string3.equals("png") || string3.equals("jpg") || string3.equals("jpeg") || string3.equals("bmp")) {
            try {
                bufferedImage = ImageIO.read(uRL);
                if (bufferedImage == null) {
                    System.err.println("Image " + string2 + " not found.");
                    return null;
                }
            }
            catch (IOException iOException) {
                System.err.println("Image " + string2 + " not found.");
            }
            this.camadas.put(string2, bufferedImage);
        } else if (string3.equals("tga")) {
            try {
                bufferedImage = TGAReader.getInstance().loadImage(uRL);
                this.camadas.put(string2, bufferedImage);
            }
            catch (IOException iOException) {
                System.err.println("Image " + string2 + " not found.");
                iOException.printStackTrace();
            }
        } else if (string3.equals("pcx")) {
            try {
                bufferedImage = PCXReader.getInstance().loadImage(uRL);
                this.camadas.put(string2, bufferedImage);
            }
            catch (IOException iOException) {
                System.err.println("Image " + string2 + " not found.");
                iOException.printStackTrace();
            }
        } else if (string3.equals("ico")) {
            try {
                bufferedImage = ICOReader.getInstance().loadImage(uRL);
                this.camadas.put(string2, bufferedImage);
            }
            catch (IOException iOException) {
                System.err.println("Image " + string2 + " not found.");
                iOException.printStackTrace();
            }
        } else if (string3.equals("gif")) {
            try {
                bufferedImage = GIFReader.getInstance().loadImage(uRL);
                this.camadas.put(string2, bufferedImage);
            }
            catch (IOException iOException) {
                System.err.println("Image " + string2 + " not found.");
                iOException.printStackTrace();
            }
        }
        return bufferedImage;
    }

    public List<ImageFrame> getAnimation(String string) {
        return this.getAnimation(string, false);
    }

    public List<ImageFrame> getAnimation(String string, boolean bl) {
        String string2 = this.getDiretorio(string, bl);
        if (this.animations.containsKey(string2)) {
            return this.animations.get(string2);
        }
        List<ImageFrame> list = null;
        URL uRL = null;
        try {
            uRL = new URL(this.url, string2);
        }
        catch (MalformedURLException malformedURLException) {
            malformedURLException.printStackTrace();
        }
        int n = string2.lastIndexOf(".");
        String string3 = string2.substring(n + 1, string2.length()).toLowerCase();
        if (string3.equals("gif")) {
            try {
                list = GIFReader.getInstance().loadAnimation(uRL);
                this.animations.put(string2, list);
            }
            catch (IOException iOException) {
                System.err.println("Image " + string2 + " not found.");
                iOException.printStackTrace();
            }
        }
        return list;
    }
}

