/*
 * Decompiled with CFR 0.152.
 */
package br.com.etyllica.gui;

import br.com.etyllica.core.event.Action;
import br.com.etyllica.core.event.GUIEvent;
import br.com.etyllica.core.event.KeyEvent;
import br.com.etyllica.core.event.PointerEvent;
import br.com.etyllica.core.graphics.Graphic;
import br.com.etyllica.gui.Panel;
import br.com.etyllica.gui.View;
import br.com.etyllica.gui.factory.DefaultButton;
import br.com.etyllica.gui.label.TextLabel;
import br.com.etyllica.gui.spinner.composer.SpinnerComposer;
import br.com.etyllica.gui.spinner.composer.VerticalComposer;

public abstract class Spinner<T extends Number>
extends View {
    protected SpinnerComposer composer;
    protected DefaultButton plus;
    protected DefaultButton minus;
    protected TextLabel resultLabel;
    protected Panel panel;
    protected T value;
    protected T step;
    protected T maxValue;
    protected T minValue;

    public Spinner(int n, int n2, int n3, int n4) {
        super(n, n2, n3, n4);
        this.panel = new Panel(n, n2, n3, n4);
        this.resultLabel = new TextLabel(n + 10, n2 + 2 + n4 / 2, "0");
        this.composer = this.buildComposer();
        this.configureButtons();
    }

    protected SpinnerComposer buildComposer() {
        return new VerticalComposer(this.x, this.y, this.w, this.h);
    }

    private void configureButtons() {
        this.composer.setBorder(1);
        this.composer.setButtonWidth(this.w / 6);
        this.plus = this.composer.buildPlusButton(this.x, this.y, this.w, this.h);
        this.plus.addAction(GUIEvent.MOUSE_LEFT_BUTTON_UP, new Action(this, "addReload"));
        this.minus = this.composer.buildMinusButton(this.x, this.y, this.w, this.h);
        this.minus.addAction(GUIEvent.MOUSE_LEFT_BUTTON_UP, new Action(this, "subReload"));
    }

    public void addReload() {
        this.add();
        this.reload();
    }

    public void subReload() {
        this.subtract();
        this.reload();
    }

    protected void reload() {
        String string = this.value.toString();
        this.resultLabel.setText(string);
    }

    public abstract void add();

    public abstract void subtract();

    @Override
    public GUIEvent updateMouse(PointerEvent pointerEvent) {
        this.plus.safeUpdateMouse(pointerEvent);
        this.minus.safeUpdateMouse(pointerEvent);
        return GUIEvent.NONE;
    }

    @Override
    public GUIEvent updateKeyboard(KeyEvent keyEvent) {
        return GUIEvent.NONE;
    }

    @Override
    public void mouseOut() {
        super.mouseOut();
        this.plus.setMouseOver(false);
        this.minus.setMouseOver(false);
    }

    @Override
    public void update(GUIEvent gUIEvent) {
    }

    @Override
    public void draw(Graphic graphic) {
        this.drawPanel(graphic);
        this.drawResult(graphic);
        this.drawButtons(graphic);
    }

    protected void drawPanel(Graphic graphic) {
        this.panel.draw(graphic);
    }

    protected void drawResult(Graphic graphic) {
        this.resultLabel.draw(graphic);
    }

    protected void drawButtons(Graphic graphic) {
        this.plus.draw(graphic);
        this.minus.draw(graphic);
    }

    public void setValue(T t) {
        this.value = t;
        this.reload();
    }

    public T getValue() {
        return this.value;
    }

    public T getStep() {
        return this.step;
    }

    public void setStep(T t) {
        this.step = t;
    }

    public T getMaxValue() {
        return this.maxValue;
    }

    public void setMaxValue(T t) {
        this.maxValue = t;
    }

    public T getMinValue() {
        return this.minValue;
    }

    public void setMinValue(T t) {
        this.minValue = t;
    }
}

