/*
 * Decompiled with CFR 0.152.
 */
package br.com.etyllica.gui.label;

import br.com.etyllica.core.Configuration;
import br.com.etyllica.core.event.GUIEvent;
import br.com.etyllica.gui.label.TextLabel;
import br.com.etyllica.i18n.Language;
import java.util.Map;

public class MultiLangLabel
extends TextLabel {
    private Map<Language, String> texts;

    public MultiLangLabel(Map<Language, String> map) {
        this(0, 0, map);
    }

    public MultiLangLabel(int n, int n2, Map<Language, String> map) {
        this(n, n2, 0, map);
    }

    public MultiLangLabel(int n, int n2, int n3, Map<Language, String> map) {
        super(n, n2, n3);
        this.texts = map;
        Language language = Configuration.getInstance().getLanguage();
        this.reloadText(language);
    }

    @Override
    public void update(GUIEvent gUIEvent) {
        if (gUIEvent == GUIEvent.LOST_FOCUS) {
            this.onFocus = false;
        } else if (gUIEvent == GUIEvent.GAIN_FOCUS) {
            this.onFocus = true;
        } else if (gUIEvent == GUIEvent.LANGUAGE_CHANGED) {
            this.reloadText(Configuration.getInstance().getLanguage());
        }
    }

    public Map<Language, String> getTexts() {
        return this.texts;
    }

    public void setTexts(Map<Language, String> map) {
        this.texts = map;
    }

    private void reloadText(Language language) {
        if (this.texts.containsKey((Object)language)) {
            this.setText(this.texts.get((Object)language));
        } else {
            this.setText(this.texts.get((Object)Language.ENGLISH_USA));
        }
    }
}

