/*
 * Decompiled with CFR 0.152.
 */
package br.com.etyllica.gui.spinner;

import br.com.etyllica.core.event.Action;
import br.com.etyllica.core.event.GUIEvent;
import br.com.etyllica.core.event.KeyEvent;
import br.com.etyllica.core.event.PointerEvent;
import br.com.etyllica.core.graphics.Graphic;
import br.com.etyllica.gui.Panel;
import br.com.etyllica.gui.View;
import br.com.etyllica.gui.factory.DefaultButton;
import br.com.etyllica.gui.label.TextLabel;
import br.com.etyllica.gui.spinner.composer.SpinnerComposer;
import br.com.etyllica.gui.spinner.composer.StringHorizontalComposer;
import java.util.ArrayList;
import java.util.List;

public class StringSpinner
extends View {
    protected SpinnerComposer composer;
    protected DefaultButton next;
    protected DefaultButton previous;
    protected TextLabel resultLabel;
    protected Panel panel;
    protected List<String> options = new ArrayList<String>();
    private int currentItem = 0;

    public StringSpinner(int n, int n2, int n3, int n4) {
        super(n, n2, n3, n4);
        this.panel = new Panel(n, n2, n3, n4);
        this.resultLabel = new TextLabel(n, n2 + 2 + n4 / 2, n3);
        this.composer = this.buildComposer();
        this.configureButtons();
    }

    protected SpinnerComposer buildComposer() {
        return new StringHorizontalComposer(this.x, this.y, this.w, this.h);
    }

    private void configureButtons() {
        this.composer.setBorder(1);
        this.composer.setButtonWidth(this.w / 6);
        this.next = this.composer.buildPlusButton(this.x, this.y, this.w, this.h);
        this.next.addAction(GUIEvent.MOUSE_LEFT_BUTTON_UP, new Action(this, "nextItem"));
        this.previous = this.composer.buildMinusButton(this.x, this.y, this.w, this.h);
        this.previous.addAction(GUIEvent.MOUSE_LEFT_BUTTON_UP, new Action(this, "previousItem"));
    }

    public void nextItem() {
        if (this.options.isEmpty()) {
            return;
        }
        ++this.currentItem;
        this.currentItem %= this.options.size();
        this.reload();
    }

    public void previousItem() {
        if (this.options.isEmpty()) {
            return;
        }
        this.currentItem += this.options.size() - 1;
        this.currentItem %= this.options.size();
        this.reload();
    }

    protected void reload() {
        if (this.options.isEmpty()) {
            return;
        }
        String string = this.options.get(this.currentItem);
        this.resultLabel.setText(string);
    }

    @Override
    public GUIEvent updateMouse(PointerEvent pointerEvent) {
        this.next.safeUpdateMouse(pointerEvent);
        this.previous.safeUpdateMouse(pointerEvent);
        return GUIEvent.NONE;
    }

    @Override
    public GUIEvent updateKeyboard(KeyEvent keyEvent) {
        return GUIEvent.NONE;
    }

    @Override
    public void mouseOut() {
        super.mouseOut();
        this.next.setMouseOver(false);
        this.previous.setMouseOver(false);
    }

    @Override
    public void update(GUIEvent gUIEvent) {
    }

    @Override
    public void draw(Graphic graphic) {
        this.drawPanel(graphic);
        this.drawResult(graphic);
        this.drawButtons(graphic);
    }

    protected void drawPanel(Graphic graphic) {
        this.panel.draw(graphic);
    }

    protected void drawResult(Graphic graphic) {
        this.resultLabel.draw(graphic);
    }

    protected void drawButtons(Graphic graphic) {
        this.next.draw(graphic);
        this.previous.draw(graphic);
    }

    public List<String> getOptions() {
        return this.options;
    }

    public void setOptions(List<String> list) {
        this.options = list;
        this.reload();
    }
}

