/*
 * Decompiled with CFR 0.152.
 */
package br.com.etyllica.layer;

import br.com.etyllica.collision.CollisionDetector;
import br.com.etyllica.core.graphics.Graphic;
import br.com.etyllica.core.graphics.SVGColor;
import br.com.etyllica.core.loader.image.ImageLoader;
import br.com.etyllica.layer.ImageLayer;
import java.awt.Color;
import java.awt.Graphics2D;
import java.awt.Image;
import java.awt.geom.AffineTransform;
import java.awt.image.AffineTransformOp;
import java.awt.image.BufferedImage;
import java.awt.image.DataBufferInt;
import java.awt.image.ImageObserver;

public class BufferedLayer
extends ImageLayer {
    protected Graphics2D graphics;
    protected BufferedImage originalBuffer;
    protected BufferedImage buffer;
    private static int MAX_INT = 255;

    public BufferedLayer(int n, int n2) {
        super(n, n2);
    }

    public BufferedLayer(int n, int n2, String string) {
        super(n, n2, string);
        this.copy(ImageLoader.getInstance().getImage(string));
    }

    public BufferedLayer(String string) {
        this(0, 0, string);
    }

    public BufferedLayer(int n, int n2, BufferedImage bufferedImage) {
        super(n, n2);
        this.w = bufferedImage.getWidth();
        this.h = bufferedImage.getHeight();
        this.copy(bufferedImage);
    }

    public BufferedLayer(int n, int n2, int n3, int n4) {
        this(n, n2);
        this.w = n3;
        this.h = n4;
        this.originalBuffer = new BufferedImage(n3, n4, 2);
        this.buffer = new BufferedImage(n3, n4, 2);
        this.clearGraphics();
    }

    public BufferedLayer(BufferedImage bufferedImage) {
        this(0, 0, bufferedImage);
    }

    public void copy(Image image) {
        if (image == null) {
            return;
        }
        int n = image.getWidth(null);
        int n2 = image.getHeight(null);
        this.w = n;
        this.h = n2;
        this.originalBuffer = new BufferedImage(n, n2, 2);
        this.graphics = this.originalBuffer.createGraphics();
        this.graphics.drawImage(image, 0, 0, null);
        this.resetImage();
    }

    public void copy(BufferedImage bufferedImage) {
        this.originalBuffer = new BufferedImage(this.w, this.h, 2);
        this.originalBuffer.getGraphics().drawImage(bufferedImage, 0, 0, null);
        this.w = bufferedImage.getWidth();
        this.h = bufferedImage.getHeight();
        this.resetImage();
    }

    public void cropImage(int n, int n2, int n3, int n4) {
        this.buffer = new BufferedImage(n3, n4, 2);
        this.graphics = this.buffer.createGraphics();
        this.graphics.drawImage((Image)this.originalBuffer, -n, -n2, null);
        this.w = n3;
        this.h = n4;
    }

    public void resetImage() {
        this.buffer = new BufferedImage(this.w, this.h, 2);
        this.graphics = this.buffer.createGraphics();
        this.graphics.drawImage((Image)this.originalBuffer, 0, 0, null);
    }

    public Graphics2D clearGraphics() {
        Graphics2D graphics2D = this.originalBuffer.createGraphics();
        graphics2D.setColor(SVGColor.TRANSPARENT);
        graphics2D.clearRect(this.x, this.y, this.w, this.h);
        this.graphics = this.buffer.createGraphics();
        this.graphics.setBackground(new Color(MAX_INT, MAX_INT, MAX_INT, 0));
        this.graphics.clearRect(0, 0, this.w, this.h);
        return this.graphics;
    }

    public void refresh() {
        this.buffer.getGraphics().drawImage(this.originalBuffer, 0, 0, null);
    }

    public void offsetRGB(int n, int n2, int n3) {
        this.resetImage();
        this.offsetPixels(n, n2, n3);
    }

    public void offsetNegativeRed(int n) {
        this.resetImage();
        this.offsetPixels(0, -n, -n);
    }

    public void offsetNegativeGreen(int n) {
        this.resetImage();
        this.offsetPixels(-n, 0, -n);
    }

    public void offsetNegativeBlue(int n) {
        this.resetImage();
        this.offsetPixels(-n, -n, 0);
    }

    private void offsetPixels(int n, int n2, int n3) {
        for (int i = 0; i < this.h; ++i) {
            for (int j = 0; j < this.w; ++j) {
                int n4 = this.originalBuffer.getRGB(j, i);
                int n5 = n4 >> 24 & 0xFF;
                int n6 = (n4 & 0xFF0000) >> 16;
                int n7 = (n4 & 0xFF00) >> 8;
                int n8 = (n4 & 0xFF) >> 0;
                n7 += n2;
                n8 += n3;
                if ((n6 += n) > MAX_INT) {
                    n6 = MAX_INT;
                } else if (n6 < 0) {
                    n6 = 0;
                }
                if (n7 > MAX_INT) {
                    n7 = MAX_INT;
                } else if (n7 < 0) {
                    n7 = 0;
                }
                if (n8 > MAX_INT) {
                    n8 = MAX_INT;
                } else if (n8 < 0) {
                    n8 = 0;
                }
                this.buffer.setRGB(j, i, new Color(n6, n7, n8, n5).getRGB());
            }
        }
    }

    public void flipVertical() {
        AffineTransform affineTransform = AffineTransform.getScaleInstance(1.0, -1.0);
        affineTransform.translate(0.0, -this.h);
        AffineTransformOp affineTransformOp = new AffineTransformOp(affineTransform, 1);
        this.buffer = affineTransformOp.filter(this.buffer, null);
    }

    public void flipHorizontal() {
        AffineTransform affineTransform = AffineTransform.getScaleInstance(-1.0, 1.0);
        affineTransform.translate(-this.w, 0.0);
        AffineTransformOp affineTransformOp = new AffineTransformOp(affineTransform, 1);
        this.buffer = affineTransformOp.filter(this.buffer, null);
    }

    public void resize(int n, int n2) {
        double d = (double)n / (double)this.originalBuffer.getWidth();
        double d2 = (double)n2 / (double)this.originalBuffer.getHeight();
        AffineTransform affineTransform = AffineTransform.getScaleInstance(d, d2);
        AffineTransformOp affineTransformOp = new AffineTransformOp(affineTransform, 1);
        this.buffer = affineTransformOp.filter(this.buffer, null);
        this.w = n;
        this.h = n2;
    }

    public void girar180() {
        AffineTransform affineTransform = AffineTransform.getScaleInstance(-1.0, -1.0);
        affineTransform.translate(-this.w, -this.h);
        AffineTransformOp affineTransformOp = new AffineTransformOp(affineTransform, 1);
        this.buffer = affineTransformOp.filter(this.buffer, null);
    }

    public byte[][][] getBytes() {
        DataBufferInt dataBufferInt = (DataBufferInt)this.buffer.getRaster().getDataBuffer();
        int[] nArray = dataBufferInt.getData();
        byte[][][] byArray = new byte[this.w][this.h][3];
        for (int i = 0; i < this.h; ++i) {
            for (int j = 0; j < this.w; ++j) {
                int n = nArray[j + i * this.w];
                byte by = (byte)((n & 0xFF0000) >> 16);
                byte by2 = (byte)((n & 0xFF00) >> 8);
                byte by3 = (byte)(n & 0xFF);
                byArray[j][i][0] = by;
                byArray[j][i][1] = by2;
                byArray[j][i][2] = by3;
            }
        }
        return byArray;
    }

    public void setBuffer(BufferedImage bufferedImage) {
        this.originalBuffer = bufferedImage;
        this.w = bufferedImage.getWidth();
        this.h = bufferedImage.getHeight();
        this.resetImage();
    }

    public BufferedImage getBuffer() {
        return this.buffer;
    }

    public boolean colideAlphaPoint(int n, int n2) {
        if (CollisionDetector.colideRectPoint(this, (double)n, (double)n2)) {
            int n3 = n - this.x;
            int n4 = n2 - this.y;
            if (n3 >= this.buffer.getWidth() || n4 >= this.buffer.getHeight()) {
                return false;
            }
            Color color = new Color(this.buffer.getRGB(n3, n4), true);
            return color.getAlpha() == MAX_INT;
        }
        return false;
    }

    public Color getColorPoint(int n, int n2) {
        if (CollisionDetector.colideRectPoint(this, (double)n, (double)n2)) {
            int n3 = n - this.x;
            int n4 = n2 - this.y;
            if (n3 >= this.buffer.getWidth() || n4 >= this.buffer.getHeight()) {
                return null;
            }
            Color color = new Color(this.buffer.getRGB(n3, n4), true);
            return color;
        }
        return null;
    }

    public Graphics2D getGraphics() {
        return this.graphics;
    }

    @Override
    public void simpleDraw(Graphic graphic, int n, int n2) {
        graphic.drawImage((Image)this.buffer, n, n2, n + this.w, n2 + this.h, this.xImage, this.yImage, this.xImage + this.w, this.yImage + this.h, (ImageObserver)null);
    }
}

