/*
 * Decompiled with CFR 0.152.
 */
package br.com.etyllica.layer;

import br.com.etyllica.collision.CollisionDetector;
import br.com.etyllica.collision.HitBox;
import br.com.etyllica.core.graphics.Graphic;
import br.com.etyllica.core.input.mouse.Mouse;
import br.com.etyllica.core.loader.image.ImageLoader;
import br.com.etyllica.layer.AnimatedLayer;
import br.com.etyllica.layer.Layer;
import br.com.etyllica.layer.StaticLayer;
import br.com.etyllica.linear.Rectangle;
import java.awt.Image;
import java.awt.image.ImageObserver;

public class ImageLayer
extends StaticLayer {
    protected int xImage = 0;
    protected int yImage = 0;
    protected HitBox colisionArea = null;

    public ImageLayer() {
    }

    public ImageLayer(int n, int n2) {
        this.x = n;
        this.y = n2;
    }

    public ImageLayer(int n, int n2, int n3, int n4) {
        super(n, n2, n3, n4);
    }

    public ImageLayer(int n, int n2, int n3, int n4, String string) {
        super(n, n2, n3, n4, string);
    }

    public ImageLayer(int n, int n2, int n3, int n4, int n5, int n6, String string) {
        super(n, n2, n3, n4, string);
        this.xImage = n5;
        this.yImage = n6;
    }

    public ImageLayer(int n, int n2, String string) {
        super(string);
        this.setCoordinates(n, n2);
    }

    public ImageLayer(String string) {
        this(0, 0, string);
    }

    public int getXImage() {
        return this.xImage;
    }

    public void setXImage(int n) {
        this.xImage = n;
    }

    public int getYImage() {
        return this.yImage;
    }

    public void setYImage(int n) {
        this.yImage = n;
    }

    public HitBox getColisionArea() {
        return this.colisionArea;
    }

    public void setColisionArea(HitBox hitBox) {
        this.colisionArea = hitBox;
    }

    public void setImageCoordinates(int n, int n2) {
        this.xImage = n;
        this.yImage = n2;
    }

    public boolean colideRetangular(int n, int n2, int n3, int n4) {
        return this.colideRect(n, n2, n3, n4);
    }

    public boolean colideRetangular(Layer layer) {
        return this.colideRetangular(layer.getX(), layer.getY(), layer.getW(), layer.getH());
    }

    private boolean colideRectangle(Rectangle rectangle, Rectangle rectangle2, int n, int n2) {
        if ((double)n + rectangle2.getX() + rectangle2.getW() < (double)this.x + rectangle.getX()) {
            return false;
        }
        if ((double)n + rectangle2.getX() > (double)this.x + rectangle.getX() + rectangle.getW()) {
            return false;
        }
        if ((double)n2 + rectangle2.getY() + rectangle2.getH() < (double)this.y + rectangle.getY()) {
            return false;
        }
        return !((double)n2 + rectangle2.getY() > (double)this.y + rectangle.getY() + rectangle.getH());
    }

    private boolean colideHitBox(Rectangle rectangle, int n, int n2) {
        for (Rectangle rectangle2 : this.colisionArea.getAreas()) {
            if (!this.colideRectangle(rectangle2, rectangle, n, n2)) continue;
            return true;
        }
        return false;
    }

    public boolean colideAreaHitBox(AnimatedLayer animatedLayer) {
        Rectangle rectangle = new Rectangle(0.0, 0.0, animatedLayer.getTileW(), animatedLayer.getTileH());
        return this.colideHitBox(rectangle, animatedLayer.getX(), animatedLayer.getY());
    }

    public boolean colideAreaHitBox(ImageLayer imageLayer) {
        Rectangle rectangle = new Rectangle(0.0, 0.0, imageLayer.getW(), imageLayer.getH());
        return this.colideHitBox(rectangle, imageLayer.getX(), imageLayer.getY());
    }

    public boolean colideHitBoxes(ImageLayer imageLayer) {
        for (Rectangle rectangle : this.colisionArea.getAreas()) {
            for (Rectangle rectangle2 : imageLayer.getColisionArea().getAreas()) {
                if (!this.colideRectangle(rectangle, rectangle2, imageLayer.getX(), imageLayer.getY())) continue;
                return true;
            }
        }
        return false;
    }

    public boolean colisionRotated(int n, int n2) {
        int n3 = this.x + this.w / 2;
        int n4 = this.y + this.h / 2;
        double d = Math.cos(this.angle);
        double d2 = Math.sin(this.angle);
        double d3 = (double)n3 + d * (double)(n - n3) - d2 * (double)(n2 - n4);
        double d4 = (double)n4 + d2 * (double)(n - n3) + d * (double)(n2 - n4);
        int n5 = n3 - this.w / 2;
        int n6 = n3 + this.w / 2;
        int n7 = n4 - this.h / 2;
        int n8 = n4 + this.h / 2;
        return (double)n5 <= d3 && d3 <= (double)n6 && (double)n7 <= d4 && d4 <= (double)n8;
    }

    @Override
    public void draw(Graphic graphic) {
        this.draw(graphic, 0, 0);
    }

    public void draw(Graphic graphic, int n, int n2) {
        if (!this.visible) {
            return;
        }
        if (this.opacity < 255) {
            graphic.setOpacity(this.opacity);
        }
        graphic.setTransform(this.getTransform(n, n2));
        this.simpleDraw(graphic);
        graphic.resetTransform();
        if (this.opacity < 255) {
            graphic.resetOpacity();
        }
    }

    @Override
    public void simpleDraw(Graphic graphic) {
        this.simpleDraw(graphic, this.x, this.y);
    }

    public void simpleDraw(Graphic graphic, int n, int n2) {
        graphic.drawImage((Image)ImageLoader.getInstance().getImage(this.path), n, n2, n + this.utilWidth(), n2 + this.utilHeight(), this.xImage, this.yImage, this.xImage + this.utilWidth(), this.yImage + this.utilHeight(), (ImageObserver)null);
    }

    public boolean onMouse(Mouse mouse) {
        return CollisionDetector.colideRectPoint(this, (double)mouse.getX(), (double)mouse.getY());
    }

    public void clone(ImageLayer imageLayer) {
        this.w = imageLayer.w;
        this.h = imageLayer.h;
        this.xImage = imageLayer.xImage;
        this.yImage = imageLayer.yImage;
        this.path = imageLayer.path;
    }
}

