/*
 * Decompiled with CFR 0.152.
 */
package br.com.etyllica.layer;

import br.com.etyllica.collision.CollisionDetector;
import br.com.etyllica.core.Drawable;
import br.com.etyllica.core.event.PointerEvent;
import br.com.etyllica.core.graphics.Graphic;
import br.com.etyllica.layer.GeometricLayer;
import java.awt.geom.AffineTransform;

public class Layer
extends GeometricLayer
implements Drawable {
    protected int opacity = 255;
    protected double angle = 0.0;
    protected double scaleX = 1.0;
    protected double scaleY = 1.0;
    protected boolean visible = true;

    public Layer() {
    }

    public Layer(int n, int n2) {
        this.x = n;
        this.y = n2;
    }

    public Layer(int n, int n2, int n3, int n4) {
        super(n, n2, n3, n4);
    }

    public int getOpacity() {
        return this.opacity;
    }

    public void setOpacity(int n) {
        this.opacity = n;
    }

    public double getAngle() {
        return this.angle;
    }

    public void setAngle(double d) {
        this.angle = d;
    }

    public void setOffsetAngle(double d) {
        this.setAngle(this.angle + d);
    }

    public double getScaleX() {
        return this.scaleX;
    }

    public double getScaleY() {
        return this.scaleY;
    }

    public void setScaleX(double d) {
        this.scaleX = d;
    }

    public void setScaleY(double d) {
        this.scaleY = d;
    }

    public void setScale(double d) {
        this.scaleX = d;
        this.scaleY = d;
    }

    public void setVisible(boolean bl) {
        this.visible = bl;
    }

    public boolean isVisible() {
        return this.visible;
    }

    public void show() {
        this.visible = true;
    }

    public void hide() {
        this.visible = false;
    }

    public void swapVisible() {
        this.visible = !this.visible;
    }

    public boolean onMouse(PointerEvent pointerEvent) {
        return this.onMouse(pointerEvent.getX(), pointerEvent.getY());
    }

    public boolean onMouse(int n, int n2) {
        if (this.scaleX == 1.0 && this.scaleY == 1.0) {
            return CollisionDetector.colideRectPoint(this, (double)n, (double)n2);
        }
        return CollisionDetector.colideRectPoint(this, n, n2, this.scaleX, this.scaleY);
    }

    public AffineTransform getTransform() {
        return this.getTransform(0, 0);
    }

    public AffineTransform getTransform(int n, int n2) {
        AffineTransform affineTransform = AffineTransform.getTranslateInstance(n, n2);
        if (this.angle != 0.0) {
            affineTransform.concatenate(AffineTransform.getRotateInstance(Math.toRadians(this.angle), this.x + this.utilWidth() / 2, this.y + this.utilHeight() / 2));
        }
        if (this.scaleX != 1.0 || this.scaleY != 1.0) {
            double d = (double)this.utilWidth() * this.scaleX;
            double d2 = (double)this.utilHeight() * this.scaleY;
            double d3 = d / 2.0 - (double)(this.utilWidth() / 2);
            double d4 = d2 / 2.0 - (double)(this.utilHeight() / 2);
            affineTransform.translate((double)(this.x - this.utilWidth() / 2) - d3, (double)(this.y - this.utilHeight() / 2) - d4);
            AffineTransform affineTransform2 = new AffineTransform();
            affineTransform2.translate(this.utilWidth() / 2, this.utilHeight() / 2);
            affineTransform2.scale(this.scaleX, this.scaleY);
            affineTransform2.translate(-this.x, -this.y);
            affineTransform.concatenate(affineTransform2);
        }
        return affineTransform;
    }

    @Override
    public void draw(Graphic graphic) {
    }

    public void simpleDraw(Graphic graphic) {
    }
}

