/*
 * Decompiled with CFR 0.152.
 */
package br.com.etyllica.linear.graph;

import br.com.etyllica.linear.Point2D;
import br.com.etyllica.linear.graph.GenericEdge;
import br.com.etyllica.linear.graph.Node;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;

public abstract class GenericComplexGraph<N, E extends GenericEdge<N>> {
    protected Set<Node<N>> nodes = new LinkedHashSet<Node<N>>();
    protected Map<Node<N>, List<E>> edges = new HashMap<Node<N>, List<E>>();

    public Set<Node<N>> getNodes() {
        return this.nodes;
    }

    public void setNodes(Set<Node<N>> set) {
        this.nodes = set;
    }

    public void addNode(Node<N> node) {
        this.nodes.add(node);
    }

    public void addNode(Point2D point2D) {
        Node node = new Node();
        node.setLocation(point2D.getX(), point2D.getY());
        this.nodes.add(node);
    }

    public Map<Node<N>, List<E>> getAllEdges() {
        return this.edges;
    }

    public List<E> getEdges(Node<N> node) {
        if (this.edges.containsKey(node)) {
            return this.edges.get(node);
        }
        return new ArrayList();
    }

    public void addEdge(E e) {
        this.addNodesFromEdge((GenericEdge<N>)e);
        Node node = ((GenericEdge)e).getOrigin();
        if (!this.edges.containsKey(node)) {
            this.edges.put(node, new ArrayList());
        }
        this.edges.get(node).add(0, e);
    }

    private void addNodesFromEdge(GenericEdge<N> genericEdge) {
        Node<N> node;
        Node<N> node2 = genericEdge.getOrigin();
        if (!this.nodes.contains(node2)) {
            this.nodes.add(node2);
        }
        if (!this.nodes.contains(node = genericEdge.getDestination())) {
            this.nodes.add(node);
        }
    }

    public boolean hasDiretionalEdge(Node<N> node, Node<N> node2) {
        for (List<E> list : this.edges.values()) {
            for (GenericEdge genericEdge : list) {
                if (genericEdge.getOrigin() != node || genericEdge.getDestination() != node2) continue;
                return true;
            }
        }
        return false;
    }

    public boolean hasEdge(Node<N> node, Node<N> node2) {
        for (List<E> list : this.edges.values()) {
            for (GenericEdge genericEdge : list) {
                if (genericEdge.getOrigin() == node && genericEdge.getDestination() == node2) {
                    return true;
                }
                if (genericEdge.getDestination() != node || genericEdge.getOrigin() != node2) continue;
                return true;
            }
        }
        return false;
    }

    public void clear() {
        this.nodes.clear();
        this.edges.clear();
    }
}

