/*
 * Decompiled with CFR 0.152.
 */
package br.com.etyllica.util.checksum;

import br.com.etyllica.util.checksum.ChecksumAlgorithm;
import java.io.FileInputStream;
import java.io.IOException;
import java.math.BigInteger;
import java.nio.charset.Charset;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;

public class Checksum {
    public String getFileCheckSum(String string, ChecksumAlgorithm checksumAlgorithm) throws NoSuchAlgorithmException, IOException {
        MessageDigest messageDigest = MessageDigest.getInstance(checksumAlgorithm.getCode());
        FileInputStream fileInputStream = new FileInputStream(string);
        byte[] byArray = new byte[1024];
        int n = 0;
        while ((n = fileInputStream.read(byArray)) != -1) {
            messageDigest.update(byArray, 0, n);
        }
        fileInputStream.close();
        byte[] byArray2 = messageDigest.digest();
        StringBuffer stringBuffer = new StringBuffer("");
        for (int i = 0; i < byArray2.length; ++i) {
            stringBuffer.append(Integer.toString((byArray2[i] & 0xFF) + 256, 16).substring(1));
        }
        return stringBuffer.toString();
    }

    public String getCheckSum(String string, ChecksumAlgorithm checksumAlgorithm) {
        String string2 = "";
        try {
            MessageDigest messageDigest = MessageDigest.getInstance("MD5");
            messageDigest.update(string.getBytes(Charset.forName("UTF8")), 0, string.length());
            string2 = new BigInteger(1, messageDigest.digest()).toString(16);
            if (string2.length() < 32) {
                string2 = "0" + string2;
            }
        }
        catch (Exception exception) {
            System.out.println("failed to create md5");
            System.out.println(exception.getMessage());
        }
        return string2;
    }
}

