/*
 * Decompiled with CFR 0.152.
 */
package br.com.etyllica.util.concurrency;

import java.util.ArrayList;
import java.util.List;

public class ConcurrentList<T> {
    private List<T> list = new ArrayList<T>();
    private List<T> alternativeList = new ArrayList<T>();
    private boolean locked = false;

    public void add(T t) {
        if (!this.locked) {
            this.list.add(t);
        } else {
            this.alternativeList.add(t);
        }
    }

    public List<T> lock() {
        this.locked = true;
        return this.list;
    }

    public void unlock() {
        this.list.clear();
        this.locked = false;
        if (!this.alternativeList.isEmpty()) {
            this.list.addAll(this.alternativeList);
            this.alternativeList.clear();
        }
    }

    public List<T> getList() {
        return this.list;
    }

    public void clear() {
        this.list.clear();
    }

    public boolean isEmpty() {
        return this.list.isEmpty() && this.alternativeList.isEmpty();
    }

    public void removeAll(List<T> list) {
        if (!this.locked) {
            for (T t : list) {
                this.list.remove(t);
            }
        }
    }
}

