/*
 * Decompiled with CFR 0.152.
 */
package br.com.tide;

import br.com.etyllica.core.Updatable;
import br.com.tide.ActivePlayerListener;
import br.com.tide.Player;
import br.com.tide.PlayerState;

public class ActivePlayer
extends Player
implements Updatable,
ActivePlayerListener {
    protected float health = 100.0f;
    protected int currentSpeed = 5;
    protected long wasHit = 0L;
    protected long hitDelay = 200L;
    protected long attackDelay = 600L;

    @Override
    public void update(long l) {
        if (this.isBeignHit() && l - this.wasHit > this.hitDelay) {
            this.stand();
        }
    }

    public void stand() {
        this.states.clear();
        this.states.add(PlayerState.STAND);
        this.onStand();
    }

    public void attack() {
        this.states.clear();
        this.states.add(PlayerState.ATTACK);
        this.onAttack();
    }

    public void specialAttack() {
        this.states.clear();
        this.states.add(PlayerState.SPECIAL_ATTACK);
        this.onSpecialAttack();
    }

    public void beignHit(ActivePlayer activePlayer, long l) {
        this.states.clear();
        this.states.add(PlayerState.BEING_HIT);
        this.onBeignHit(activePlayer);
        this.wasHit = l;
    }

    public void stopAttack() {
        this.stand();
        this.onStopAttack();
    }

    public void die() {
        this.states.clear();
        this.states.add(PlayerState.DEAD);
        this.onDie();
    }

    public boolean isAttacking() {
        return this.states.contains((Object)PlayerState.ATTACK);
    }

    public boolean isStanding() {
        return this.states.contains((Object)PlayerState.STAND);
    }

    public boolean isDead() {
        return this.states.contains((Object)PlayerState.DEAD);
    }

    public boolean isBeignHit() {
        return this.states.contains((Object)PlayerState.BEING_HIT);
    }

    @Override
    public void onAttack() {
    }

    @Override
    public void onStopAttack() {
    }

    @Override
    public void onSpecialAttack() {
    }

    @Override
    public void onStopSpecialAttack() {
    }

    @Override
    public void onStand() {
    }

    @Override
    public void onBeignHit(ActivePlayer activePlayer) {
    }

    @Override
    public void onDie() {
    }

    public void walkAction() {
    }

    public void jumpAction() {
    }
}

