/*
 * Decompiled with CFR 0.152.
 */
package br.com.tide.action.player;

import br.com.tide.ActivePlayer;
import br.com.tide.PlayerState;
import br.com.tide.action.player.ActionPlayerListener;
import br.com.tide.input.ControllerListener;

public class ActionPlayer
extends ActivePlayer
implements ControllerListener {
    protected double dx = 0.0;
    protected double dy = 0.0;
    protected double angle = 0.0;
    protected double startAngle = 90.0;
    protected double turnSpeed = 5.0;
    protected double backWalkSpeed = 1.5;
    private boolean hasListener = false;
    private ActionPlayerListener listener;

    public ActionPlayer(int n, int n2) {
        this.x = n;
        this.y = n2;
        this.dx = n;
        this.dy = n2;
    }

    public ActionPlayer(int n, int n2, ActionPlayerListener actionPlayerListener) {
        this(n, n2);
        this.hasListener = true;
        this.listener = actionPlayerListener;
    }

    @Override
    public void update(long l) {
        super.update(l);
        if (this.hasState(PlayerState.TURN_LEFT)) {
            this.angle -= this.turnSpeed;
        }
        if (this.hasState(PlayerState.TURN_RIGHT)) {
            this.angle += this.turnSpeed;
        }
        if (this.hasState(PlayerState.WALK_FORWARD)) {
            this.moveForward();
        }
        if (this.hasState(PlayerState.WALK_BACKWARD)) {
            this.moveBackward();
        }
    }

    public void turnLeft() {
        if (this.hasListener) {
            this.listener.onTurnLeft(this);
        }
        this.states.add(PlayerState.TURN_LEFT);
    }

    public void stopTurnLeft() {
        this.states.remove((Object)PlayerState.TURN_LEFT);
        if (this.hasListener) {
            this.listener.onStopTurnLeft(this);
        }
    }

    public void turnRight() {
        if (this.hasListener) {
            this.listener.onTurnRight(this);
        }
        this.states.add(PlayerState.TURN_RIGHT);
    }

    public void stopTurnRight() {
        this.states.remove((Object)PlayerState.TURN_RIGHT);
        if (this.hasListener) {
            this.listener.onStopTurnRight(this);
        }
    }

    public void walkForward() {
        if (this.hasListener) {
            this.listener.onWalkForward(this);
        }
        this.states.add(PlayerState.WALK_FORWARD);
    }

    public void stopWalkForward() {
        this.states.remove((Object)PlayerState.WALK_FORWARD);
        if (this.hasListener) {
            this.listener.onStopWalkForward(this);
        }
    }

    public void walkBackward() {
        if (this.hasListener) {
            this.listener.onWalkBackward(this);
        }
        this.states.add(PlayerState.WALK_BACKWARD);
    }

    public void stopWalkBackward() {
        this.states.remove((Object)PlayerState.WALK_BACKWARD);
        if (this.hasListener) {
            this.listener.onStopWalkBackward(this);
        }
    }

    private void move(double d, double d2) {
        this.dx += Math.sin(Math.toRadians(d)) * d2;
        this.dy -= Math.cos(Math.toRadians(d)) * d2;
        this.x = (int)this.dx;
        this.y = (int)this.dy;
    }

    private void moveForward() {
        this.move(this.angle + this.startAngle, this.currentSpeed);
    }

    public void undoMoveForward() {
        this.move(this.angle + this.startAngle, -this.currentSpeed);
    }

    private void moveBackward() {
        double d = 180.0 + this.angle + this.startAngle;
        this.move(d, this.backWalkSpeed);
    }

    public void undoMoveBackward() {
        double d = 180.0 + this.angle + this.startAngle;
        this.move(d, -this.backWalkSpeed);
    }

    public void stopWalk() {
        this.states.remove((Object)PlayerState.WALK_FORWARD);
        this.states.remove((Object)PlayerState.WALK_BACKWARD);
    }

    public boolean isWalking() {
        return this.states.contains((Object)PlayerState.WALK_FORWARD) || this.states.contains((Object)PlayerState.WALK_BACKWARD);
    }

    public boolean isTurning() {
        return this.states.contains((Object)PlayerState.TURN_LEFT) || this.states.contains((Object)PlayerState.TURN_RIGHT);
    }

    @Override
    public void onUpButtonPressed() {
        this.walkForward();
    }

    @Override
    public void onUpButtonReleased() {
        this.stopWalkForward();
    }

    @Override
    public void onDownButtonPressed() {
        this.walkBackward();
    }

    @Override
    public void onDownButtonReleased() {
        this.stopWalkBackward();
    }

    @Override
    public void onRightButtonPressed() {
        this.turnRight();
    }

    @Override
    public void onRightButtonReleased() {
        this.stopTurnRight();
    }

    @Override
    public void onLeftButtonPressed() {
        this.turnLeft();
    }

    @Override
    public void onLeftButtonReleased() {
        this.stopTurnLeft();
    }

    @Override
    public void onAButtonPressed() {
    }

    @Override
    public void onAButtonReleased() {
    }

    @Override
    public void onBButtonPressed() {
    }

    @Override
    public void onBButtonReleased() {
    }

    @Override
    public void onCButtonPressed() {
    }

    @Override
    public void onCButtonReleased() {
    }

    @Override
    public void onXButtonPressed() {
    }

    @Override
    public void onXButtonReleased() {
    }

    @Override
    public void onYButtonPressed() {
    }

    @Override
    public void onYButtonReleased() {
    }

    @Override
    public void onZButtonPressed() {
    }

    @Override
    public void onZButtonReleased() {
        this.setX(this.x);
    }

    @Override
    public void setX(int n) {
        super.setX(n);
        this.dx = n;
    }

    @Override
    public void setY(int n) {
        super.setY(n);
        this.dy = n;
    }

    public void setOffsetX(int n) {
        this.dx += (double)n;
        this.x += n;
    }

    public void setOffsetY(int n) {
        this.dy += (double)n;
        this.y += n;
    }

    public double getDx() {
        return this.dx;
    }

    public double getDy() {
        return this.dy;
    }

    public double getAngle() {
        return this.angle;
    }

    public void setAngle(double d) {
        this.angle = d;
    }

    public double getStartAngle() {
        return this.startAngle;
    }

    public void setStartAngle(double d) {
        this.startAngle = d;
    }

    public void setListener(ActionPlayerListener actionPlayerListener) {
        this.listener = actionPlayerListener;
        this.hasListener = null == actionPlayerListener;
    }
}

