/*
 * Decompiled with CFR 0.152.
 */
package sound.capture;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import javax.sound.sampled.AudioFormat;
import javax.sound.sampled.AudioInputStream;
import javax.sound.sampled.AudioSystem;
import javax.sound.sampled.DataLine;
import javax.sound.sampled.LineUnavailableException;
import javax.sound.sampled.SourceDataLine;
import javax.sound.sampled.TargetDataLine;

public class CaptureHandler {
    private boolean recording = false;
    private ByteArrayOutputStream inputBuffer;
    private static CaptureHandler instance = null;
    private TargetDataLine line;

    public static CaptureHandler getInstance() {
        if (instance == null) {
            instance = new CaptureHandler();
        }
        return instance;
    }

    public synchronized void captureAudio() {
        try {
            final AudioFormat audioFormat = this.getFormat();
            DataLine.Info info = new DataLine.Info(TargetDataLine.class, audioFormat);
            this.line = (TargetDataLine)AudioSystem.getLine(info);
            this.line.open(audioFormat);
            this.line.start();
            Runnable runnable = new Runnable(){
                int bufferSize;
                byte[] buffer;
                {
                    this.bufferSize = (int)audioFormat.getSampleRate() * audioFormat.getFrameSize();
                    this.buffer = new byte[this.bufferSize];
                }

                @Override
                public void run() {
                    CaptureHandler.this.inputBuffer = new ByteArrayOutputStream();
                    CaptureHandler.this.recording = true;
                    try {
                        while (CaptureHandler.this.recording) {
                            int n = CaptureHandler.this.line.read(this.buffer, 0, this.buffer.length);
                            if (n <= 0) continue;
                            CaptureHandler.this.inputBuffer.write(this.buffer, 0, n);
                        }
                        CaptureHandler.this.inputBuffer.close();
                    }
                    catch (IOException iOException) {
                        System.err.println("I/O problems: " + iOException);
                        System.exit(-1);
                    }
                }
            };
            Thread thread = new Thread(runnable);
            thread.start();
        }
        catch (LineUnavailableException lineUnavailableException) {
            System.err.println("Line unavailable: " + lineUnavailableException);
        }
    }

    public synchronized void stopCapture() {
        this.recording = false;
    }

    public synchronized void playAudio() {
        try {
            byte[] byArray = this.inputBuffer.toByteArray();
            ByteArrayInputStream byteArrayInputStream = new ByteArrayInputStream(byArray);
            final AudioFormat audioFormat = this.getFormat();
            final AudioInputStream audioInputStream = new AudioInputStream(byteArrayInputStream, audioFormat, byArray.length / audioFormat.getFrameSize());
            DataLine.Info info = new DataLine.Info(SourceDataLine.class, audioFormat);
            final SourceDataLine sourceDataLine = (SourceDataLine)AudioSystem.getLine(info);
            sourceDataLine.open(audioFormat);
            sourceDataLine.start();
            Runnable runnable = new Runnable(){
                int bufferSize;
                byte[] buffer;
                {
                    this.bufferSize = (int)audioFormat.getSampleRate() * audioFormat.getFrameSize();
                    this.buffer = new byte[this.bufferSize];
                }

                @Override
                public void run() {
                    try {
                        int n;
                        while ((n = audioInputStream.read(this.buffer, 0, this.buffer.length)) != -1) {
                            if (n <= 0) continue;
                            sourceDataLine.write(this.buffer, 0, n);
                        }
                        sourceDataLine.drain();
                        sourceDataLine.close();
                    }
                    catch (IOException iOException) {
                        System.err.println("I/O problems: " + iOException);
                    }
                }
            };
            Thread thread = new Thread(runnable);
            thread.start();
        }
        catch (LineUnavailableException lineUnavailableException) {
            System.err.println("Line unavailable: " + lineUnavailableException);
        }
    }

    public int[][] getWaveformSamples() {
        byte[] byArray = this.inputBuffer.toByteArray();
        AudioInputStream audioInputStream = new AudioInputStream(this.line);
        int n = audioInputStream.getFormat().getChannels();
        int n2 = byArray.length;
        int[][] nArray = new int[n][n2];
        int n3 = 0;
        int n4 = 0;
        while (n4 < byArray.length) {
            for (int i = 0; i < n; ++i) {
                int n5;
                byte by = byArray[n4];
                byte by2 = byArray[++n4];
                ++n4;
                nArray[i][n3] = n5 = this.getSixteenBitSample(by2, by);
            }
            ++n3;
        }
        return nArray;
    }

    private int getSixteenBitSample(int n, int n2) {
        return (n << 8) + (n2 & 0xFF);
    }

    private AudioFormat getFormat() {
        float f = 8000.0f;
        int n = 8;
        int n2 = 1;
        boolean bl = true;
        boolean bl2 = true;
        AudioFormat audioFormat = new AudioFormat(f, n, n2, bl, bl2);
        return audioFormat;
    }

    public ByteArrayOutputStream getInputBuffer() {
        return this.inputBuffer;
    }

    public void setInputBuffer(ByteArrayOutputStream byteArrayOutputStream) {
        this.inputBuffer = byteArrayOutputStream;
    }
}

