/*
 * Decompiled with CFR 0.152.
 */
package sound.jarnbjo.vorbis;

import java.io.IOException;
import sound.jarnbjo.util.io.BitInputStream;
import sound.jarnbjo.vorbis.CodeBook;
import sound.jarnbjo.vorbis.Floor;
import sound.jarnbjo.vorbis.Mapping;
import sound.jarnbjo.vorbis.Mode;
import sound.jarnbjo.vorbis.Residue;
import sound.jarnbjo.vorbis.VorbisFormatException;
import sound.jarnbjo.vorbis.VorbisStream;

public class SetupHeader {
    private static final long HEADER = 126896460427126L;
    private CodeBook[] codeBooks;
    private Floor[] floors;
    private Residue[] residues;
    private Mapping[] mappings;
    private Mode[] modes;

    public SetupHeader(VorbisStream vorbisStream, BitInputStream bitInputStream) throws VorbisFormatException, IOException {
        int n;
        int n2;
        int n3;
        int n4;
        int n5;
        if (bitInputStream.getLong(48) != 126896460427126L) {
            throw new VorbisFormatException("The setup header has an illegal leading.");
        }
        int n6 = bitInputStream.getInt(8) + 1;
        this.codeBooks = new CodeBook[n6];
        for (n5 = 0; n5 < this.codeBooks.length; ++n5) {
            this.codeBooks[n5] = new CodeBook(bitInputStream);
        }
        n5 = bitInputStream.getInt(6) + 1;
        for (n4 = 0; n4 < n5; ++n4) {
            if (bitInputStream.getInt(16) == 0) continue;
            throw new VorbisFormatException("Time domain transformation != 0");
        }
        n4 = bitInputStream.getInt(6) + 1;
        this.floors = new Floor[n4];
        for (n3 = 0; n3 < n4; ++n3) {
            this.floors[n3] = Floor.createInstance(bitInputStream, this);
        }
        n3 = bitInputStream.getInt(6) + 1;
        this.residues = new Residue[n3];
        for (n2 = 0; n2 < n3; ++n2) {
            this.residues[n2] = Residue.createInstance(bitInputStream, this);
        }
        n2 = bitInputStream.getInt(6) + 1;
        this.mappings = new Mapping[n2];
        for (n = 0; n < n2; ++n) {
            this.mappings[n] = Mapping.createInstance(vorbisStream, bitInputStream, this);
        }
        n = bitInputStream.getInt(6) + 1;
        this.modes = new Mode[n];
        for (int i = 0; i < n; ++i) {
            this.modes[i] = new Mode(bitInputStream, this);
        }
        if (!bitInputStream.getBit()) {
            throw new VorbisFormatException("The setup header framing bit is incorrect.");
        }
    }

    public CodeBook[] getCodeBooks() {
        return this.codeBooks;
    }

    public Floor[] getFloors() {
        return this.floors;
    }

    public Residue[] getResidues() {
        return this.residues;
    }

    public Mapping[] getMappings() {
        return this.mappings;
    }

    public Mode[] getModes() {
        return this.modes;
    }
}

