/*
 * Decompiled with CFR 0.152.
 */
package sound.jarnbjo.vorbis;

import java.io.IOException;
import java.util.Arrays;
import java.util.LinkedList;
import sound.jarnbjo.ogg.LogicalOggStream;
import sound.jarnbjo.util.io.ByteArrayBitInputStream;
import sound.jarnbjo.vorbis.AudioPacket;
import sound.jarnbjo.vorbis.CommentHeader;
import sound.jarnbjo.vorbis.IdentificationHeader;
import sound.jarnbjo.vorbis.SetupHeader;
import sound.jarnbjo.vorbis.VorbisFormatException;

public class VorbisStream {
    private LogicalOggStream oggStream;
    private IdentificationHeader identificationHeader;
    private CommentHeader commentHeader;
    private SetupHeader setupHeader;
    private AudioPacket lastAudioPacket;
    private AudioPacket nextAudioPacket;
    private LinkedList audioPackets = new LinkedList();
    private byte[] currentPcm;
    private int currentPcmIndex;
    private int currentPcmLimit;
    private static final int IDENTIFICATION_HEADER = 1;
    private static final int COMMENT_HEADER = 3;
    private static final int SETUP_HEADER = 5;
    private int bitIndex = 0;
    private byte lastByte = 0;
    private boolean initialized = false;
    private Object streamLock = new Object();
    private int pageCounter = 0;
    private int currentBitRate = 0;
    private long currentGranulePosition;
    public static final int BIG_ENDIAN = 0;
    public static final int LITTLE_ENDIAN = 1;

    public VorbisStream() {
    }

    public VorbisStream(LogicalOggStream logicalOggStream) throws VorbisFormatException, IOException {
        this.oggStream = logicalOggStream;
        block5: for (int i = 0; i < 3; ++i) {
            ByteArrayBitInputStream byteArrayBitInputStream = new ByteArrayBitInputStream(logicalOggStream.getNextOggPacket());
            int n = byteArrayBitInputStream.getInt(8);
            switch (n) {
                case 1: {
                    this.identificationHeader = new IdentificationHeader(byteArrayBitInputStream);
                    continue block5;
                }
                case 3: {
                    this.commentHeader = new CommentHeader(byteArrayBitInputStream);
                    continue block5;
                }
                case 5: {
                    this.setupHeader = new SetupHeader(this, byteArrayBitInputStream);
                }
            }
        }
        if (this.identificationHeader == null) {
            throw new VorbisFormatException("The file has no identification header.");
        }
        if (this.commentHeader == null) {
            throw new VorbisFormatException("The file has no commentHeader.");
        }
        if (this.setupHeader == null) {
            throw new VorbisFormatException("The file has no setup header.");
        }
        this.currentPcm = new byte[this.identificationHeader.getChannels() * this.identificationHeader.getBlockSize1() * 2];
    }

    public IdentificationHeader getIdentificationHeader() {
        return this.identificationHeader;
    }

    public CommentHeader getCommentHeader() {
        return this.commentHeader;
    }

    protected SetupHeader getSetupHeader() {
        return this.setupHeader;
    }

    public boolean isOpen() {
        return this.oggStream.isOpen();
    }

    public void close() throws IOException {
        this.oggStream.close();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int readPcm(byte[] byArray, int n, int n2) throws IOException {
        Object object = this.streamLock;
        synchronized (object) {
            int n3 = this.identificationHeader.getChannels();
            if (this.lastAudioPacket == null) {
                this.lastAudioPacket = this.getNextAudioPacket();
            }
            if (this.currentPcm == null || this.currentPcmIndex >= this.currentPcmLimit) {
                AudioPacket audioPacket = this.getNextAudioPacket();
                try {
                    audioPacket.getPcm(this.lastAudioPacket, this.currentPcm);
                    this.currentPcmLimit = audioPacket.getNumberOfSamples() * this.identificationHeader.getChannels() * 2;
                }
                catch (ArrayIndexOutOfBoundsException arrayIndexOutOfBoundsException) {
                    return 0;
                }
                this.currentPcmIndex = 0;
                this.lastAudioPacket = audioPacket;
            }
            int n4 = 0;
            int n5 = 0;
            int n6 = 0;
            for (n5 = this.currentPcmIndex; n5 < this.currentPcmLimit && n6 < n2; ++n5) {
                byArray[n + n6++] = this.currentPcm[n5];
                ++n4;
            }
            this.currentPcmIndex = n5;
            return n4;
        }
    }

    private AudioPacket getNextAudioPacket() throws VorbisFormatException, IOException {
        ++this.pageCounter;
        byte[] byArray = this.oggStream.getNextOggPacket();
        AudioPacket audioPacket = null;
        while (audioPacket == null) {
            try {
                audioPacket = new AudioPacket(this, new ByteArrayBitInputStream(byArray));
            }
            catch (ArrayIndexOutOfBoundsException arrayIndexOutOfBoundsException) {}
        }
        this.currentGranulePosition += (long)audioPacket.getNumberOfSamples();
        this.currentBitRate = byArray.length * 8 * this.identificationHeader.getSampleRate() / audioPacket.getNumberOfSamples();
        return audioPacket;
    }

    public long getCurrentGranulePosition() {
        return this.currentGranulePosition;
    }

    public int getCurrentBitRate() {
        return this.currentBitRate;
    }

    public byte[] processPacket(byte[] byArray) throws VorbisFormatException, IOException {
        if (byArray.length == 0) {
            throw new VorbisFormatException("Cannot decode a vorbis packet with length = 0");
        }
        if ((byArray[0] & 1) == 1) {
            ByteArrayBitInputStream byteArrayBitInputStream = new ByteArrayBitInputStream(byArray);
            switch (byteArrayBitInputStream.getInt(8)) {
                case 1: {
                    this.identificationHeader = new IdentificationHeader(byteArrayBitInputStream);
                    break;
                }
                case 3: {
                    this.commentHeader = new CommentHeader(byteArrayBitInputStream);
                    break;
                }
                case 5: {
                    this.setupHeader = new SetupHeader(this, byteArrayBitInputStream);
                }
            }
            return null;
        }
        if (this.identificationHeader == null || this.commentHeader == null || this.setupHeader == null) {
            throw new VorbisFormatException("Cannot decode audio packet before all three header packets have been decoded.");
        }
        AudioPacket audioPacket = new AudioPacket(this, new ByteArrayBitInputStream(byArray));
        this.currentGranulePosition += (long)audioPacket.getNumberOfSamples();
        if (this.lastAudioPacket == null) {
            this.lastAudioPacket = audioPacket;
            return null;
        }
        byte[] byArray2 = new byte[this.identificationHeader.getChannels() * audioPacket.getNumberOfSamples() * 2];
        try {
            audioPacket.getPcm(this.lastAudioPacket, byArray2);
        }
        catch (IndexOutOfBoundsException indexOutOfBoundsException) {
            Arrays.fill(byArray2, (byte)0);
        }
        this.lastAudioPacket = audioPacket;
        return byArray2;
    }
}

