/*
 * Decompiled with CFR 0.152.
 */
package sound.musicg.dsp;

public class WindowFunction {
    public static final int RECTANGULAR = 0;
    public static final int BARTLETT = 1;
    public static final int HANNING = 2;
    public static final int HAMMING = 3;
    public static final int BLACKMAN = 4;
    int windowType = 0;

    public void setWindowType(int n) {
        this.windowType = n;
    }

    public void setWindowType(String string) {
        if (string.toUpperCase().equals("RECTANGULAR")) {
            this.windowType = 0;
        }
        if (string.toUpperCase().equals("BARTLETT")) {
            this.windowType = 1;
        }
        if (string.toUpperCase().equals("HANNING")) {
            this.windowType = 2;
        }
        if (string.toUpperCase().equals("HAMMING")) {
            this.windowType = 3;
        }
        if (string.toUpperCase().equals("BLACKMAN")) {
            this.windowType = 4;
        }
    }

    public int getWindowType() {
        return this.windowType;
    }

    public double[] generate(int n) {
        int n2 = n / 2;
        double d = Math.PI;
        double[] dArray = new double[n];
        switch (this.windowType) {
            case 1: {
                for (int i = 0; i < n; ++i) {
                    dArray[i] = 1.0f - (float)(Math.abs(i - n2) / n2);
                }
                break;
            }
            case 2: {
                double d2 = d / (double)(n2 + 1);
                for (int i = -n2; i < n2; ++i) {
                    dArray[n2 + i] = 0.5 + 0.5 * Math.cos((double)i * d2);
                }
                break;
            }
            case 3: {
                double d3 = d / (double)n2;
                for (int i = -n2; i < n2; ++i) {
                    dArray[n2 + i] = (double)0.54f + (double)0.46f * Math.cos((double)i * d3);
                }
                break;
            }
            case 4: {
                double d4 = d / (double)n2;
                for (int i = -n2; i < n2; ++i) {
                    dArray[n2 + i] = (double)0.42f + 0.5 * Math.cos((double)i * d4) + (double)0.08f * Math.cos((double)(2 * i) * d4);
                }
                break;
            }
            default: {
                for (int i = 0; i < n; ++i) {
                    dArray[i] = 1.0;
                }
            }
        }
        return dArray;
    }
}

