/*
 * Decompiled with CFR 0.152.
 */
package sound.musicg.fingerprint;

import java.util.HashMap;
import java.util.List;
import sound.musicg.fingerprint.FingerprintManager;
import sound.musicg.fingerprint.FingerprintSimilarity;
import sound.musicg.fingerprint.PairManager;
import sound.musicg.math.rank.MapRankInteger;

public class FingerprintSimilarityComputer {
    private FingerprintSimilarity fingerprintSimilarity;
    byte[] fingerprint1;
    byte[] fingerprint2;

    public FingerprintSimilarityComputer(byte[] byArray, byte[] byArray2) {
        this.fingerprint1 = byArray;
        this.fingerprint2 = byArray2;
        this.fingerprintSimilarity = new FingerprintSimilarity();
    }

    public FingerprintSimilarity getFingerprintsSimilarity() {
        float f;
        List<Integer> list;
        HashMap<Integer, Integer> hashMap = new HashMap<Integer, Integer>();
        int n = 0;
        float f2 = 0.0f;
        int n2 = Integer.MIN_VALUE;
        n = this.fingerprint1.length > this.fingerprint2.length ? FingerprintManager.getNumFrames(this.fingerprint2) : FingerprintManager.getNumFrames(this.fingerprint1);
        PairManager pairManager = new PairManager();
        HashMap<Integer, List<Integer>> hashMap2 = pairManager.getPair_PositionList_Table(this.fingerprint1);
        HashMap<Integer, List<Integer>> hashMap3 = pairManager.getPair_PositionList_Table(this.fingerprint2);
        for (int n3 : hashMap3.keySet()) {
            if (!hashMap2.containsKey(n3) || !hashMap3.containsKey(n3)) continue;
            list = hashMap2.get(n3);
            List<Integer> list2 = hashMap3.get(n3);
            for (int n4 : list) {
                for (int n5 : list2) {
                    int n6 = n4 - n5;
                    if (hashMap.containsKey(n6)) {
                        hashMap.put(n6, (Integer)hashMap.get(n6) + 1);
                        continue;
                    }
                    hashMap.put(n6, 1);
                }
            }
        }
        MapRankInteger mapRankInteger = new MapRankInteger(hashMap, false);
        list = mapRankInteger.getOrderedKeyList(100, true);
        if (list.size() > 0) {
            int n7 = (Integer)list.get(0);
            if (n2 == Integer.MIN_VALUE) {
                n2 = n7;
                f2 = ((Integer)hashMap.get(n7)).intValue();
                if (hashMap.containsKey(n7 - 1)) {
                    f2 += (float)((Integer)hashMap.get(n7 - 1) / 2);
                }
                if (hashMap.containsKey(n7 + 1)) {
                    f2 += (float)((Integer)hashMap.get(n7 + 1) / 2);
                }
            }
        }
        if ((f = (f2 /= (float)n)) > 1.0f) {
            f = 1.0f;
        }
        this.fingerprintSimilarity.setMostSimilarFramePosition(n2);
        this.fingerprintSimilarity.setScore(f2);
        this.fingerprintSimilarity.setSimilarity(f);
        return this.fingerprintSimilarity;
    }
}

