/*
 * Decompiled with CFR 0.152.
 */
package sound.musicg.processor;

import sound.musicg.math.rank.ArrayRankDouble;
import sound.musicg.processor.IntensityProcessor;

public class RobustIntensityProcessor
implements IntensityProcessor {
    private double[][] intensities;
    private int numPointsPerFrame;

    public RobustIntensityProcessor(double[][] dArray, int n) {
        this.intensities = dArray;
        this.numPointsPerFrame = n;
    }

    @Override
    public void execute() {
        int n = this.intensities.length;
        int n2 = this.intensities[0].length;
        double[][] dArray = new double[n][n2];
        for (int i = 0; i < n; ++i) {
            double[] dArray2 = new double[n2];
            System.arraycopy(this.intensities[i], 0, dArray2, 0, n2);
            ArrayRankDouble arrayRankDouble = new ArrayRankDouble();
            double d = arrayRankDouble.getNthOrderedValue(dArray2, this.numPointsPerFrame, false);
            for (int j = 0; j < n2; ++j) {
                if (!(this.intensities[i][j] >= d)) continue;
                dArray[i][j] = this.intensities[i][j];
            }
        }
        this.intensities = dArray;
    }

    @Override
    public double[][] getIntensities() {
        return this.intensities;
    }
}

