/*
 * Decompiled with CFR 0.152.
 */
package sound.musicg.wave;

import java.io.IOException;
import java.io.InputStream;

public class WaveHeader {
    public static final String RIFF_HEADER = "RIFF";
    public static final String WAVE_HEADER = "WAVE";
    public static final String FMT_HEADER = "fmt ";
    public static final String DATA_HEADER = "data";
    public static final int HEADER_BYTE_LENGTH = 44;
    private boolean valid;
    private String chunkId;
    private long chunkSize;
    private String format;
    private String subChunk1Id;
    private long subChunk1Size;
    private int audioFormat;
    private int channels;
    private long sampleRate;
    private long byteRate;
    private int blockAlign;
    private int bitsPerSample;
    private String subChunk2Id;
    private long subChunk2Size;

    public WaveHeader() {
        this.chunkSize = 36L;
        this.subChunk1Size = 16L;
        this.audioFormat = 1;
        this.channels = 1;
        this.sampleRate = 8000L;
        this.byteRate = 16000L;
        this.blockAlign = 2;
        this.bitsPerSample = 16;
        this.subChunk2Size = 0L;
        this.valid = true;
    }

    public WaveHeader(InputStream inputStream) {
        this.valid = this.loadHeader(inputStream);
    }

    private boolean loadHeader(InputStream inputStream) {
        byte[] byArray = new byte[44];
        try {
            inputStream.read(byArray);
            int n = 0;
            this.chunkId = new String(new byte[]{byArray[n++], byArray[n++], byArray[n++], byArray[n++]});
            this.chunkSize = (long)(byArray[n++] & 0xFF) | (long)(byArray[n++] & 0xFF) << 8 | (long)(byArray[n++] & 0xFF) << 16 | (long)(byArray[n++] & 0xFF000000);
            this.format = new String(new byte[]{byArray[n++], byArray[n++], byArray[n++], byArray[n++]});
            this.subChunk1Id = new String(new byte[]{byArray[n++], byArray[n++], byArray[n++], byArray[n++]});
            this.subChunk1Size = (long)(byArray[n++] & 0xFF) | (long)(byArray[n++] & 0xFF) << 8 | (long)(byArray[n++] & 0xFF) << 16 | (long)(byArray[n++] & 0xFF) << 24;
            this.audioFormat = byArray[n++] & 0xFF | (byArray[n++] & 0xFF) << 8;
            this.channels = byArray[n++] & 0xFF | (byArray[n++] & 0xFF) << 8;
            this.sampleRate = (long)(byArray[n++] & 0xFF) | (long)(byArray[n++] & 0xFF) << 8 | (long)(byArray[n++] & 0xFF) << 16 | (long)(byArray[n++] & 0xFF) << 24;
            this.byteRate = (long)(byArray[n++] & 0xFF) | (long)(byArray[n++] & 0xFF) << 8 | (long)(byArray[n++] & 0xFF) << 16 | (long)(byArray[n++] & 0xFF) << 24;
            this.blockAlign = byArray[n++] & 0xFF | (byArray[n++] & 0xFF) << 8;
            this.bitsPerSample = byArray[n++] & 0xFF | (byArray[n++] & 0xFF) << 8;
            this.subChunk2Id = new String(new byte[]{byArray[n++], byArray[n++], byArray[n++], byArray[n++]});
            this.subChunk2Size = (long)(byArray[n++] & 0xFF) | (long)(byArray[n++] & 0xFF) << 8 | (long)(byArray[n++] & 0xFF) << 16 | (long)(byArray[n++] & 0xFF) << 24;
        }
        catch (IOException iOException) {
            iOException.printStackTrace();
            return false;
        }
        if (this.bitsPerSample != 8 && this.bitsPerSample != 16) {
            System.err.println("WaveHeader: only supports bitsPerSample 8 or 16");
            return false;
        }
        if (this.chunkId.toUpperCase().equals(RIFF_HEADER) && this.format.toUpperCase().equals(WAVE_HEADER) && this.audioFormat == 1) {
            return true;
        }
        System.err.println("WaveHeader: Unsupported header format");
        return false;
    }

    public boolean isValid() {
        return this.valid;
    }

    public String getChunkId() {
        return this.chunkId;
    }

    public long getChunkSize() {
        return this.chunkSize;
    }

    public String getFormat() {
        return this.format;
    }

    public String getSubChunk1Id() {
        return this.subChunk1Id;
    }

    public long getSubChunk1Size() {
        return this.subChunk1Size;
    }

    public int getAudioFormat() {
        return this.audioFormat;
    }

    public int getChannels() {
        return this.channels;
    }

    public int getSampleRate() {
        return (int)this.sampleRate;
    }

    public int getByteRate() {
        return (int)this.byteRate;
    }

    public int getBlockAlign() {
        return this.blockAlign;
    }

    public int getBitsPerSample() {
        return this.bitsPerSample;
    }

    public String getSubChunk2Id() {
        return this.subChunk2Id;
    }

    public long getSubChunk2Size() {
        return this.subChunk2Size;
    }

    public void setSampleRate(int n) {
        int n2 = (int)(this.subChunk2Size * (long)n / this.sampleRate);
        if (this.bitsPerSample / 8 % 2 == 0 && n2 % 2 != 0) {
            ++n2;
        }
        this.sampleRate = n;
        this.byteRate = n * this.bitsPerSample / 8;
        this.chunkSize = n2 + 36;
        this.subChunk2Size = n2;
    }

    public void setChunkId(String string) {
        this.chunkId = string;
    }

    public void setChunkSize(long l) {
        this.chunkSize = l;
    }

    public void setFormat(String string) {
        this.format = string;
    }

    public void setSubChunk1Id(String string) {
        this.subChunk1Id = string;
    }

    public void setSubChunk1Size(long l) {
        this.subChunk1Size = l;
    }

    public void setAudioFormat(int n) {
        this.audioFormat = n;
    }

    public void setChannels(int n) {
        this.channels = n;
    }

    public void setByteRate(long l) {
        this.byteRate = l;
    }

    public void setBlockAlign(int n) {
        this.blockAlign = n;
    }

    public void setBitsPerSample(int n) {
        this.bitsPerSample = n;
    }

    public void setSubChunk2Id(String string) {
        this.subChunk2Id = string;
    }

    public void setSubChunk2Size(long l) {
        this.subChunk2Size = l;
    }

    public String toString() {
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append("chunkId: " + this.chunkId);
        stringBuffer.append("\n");
        stringBuffer.append("chunkSize: " + this.chunkSize);
        stringBuffer.append("\n");
        stringBuffer.append("format: " + this.format);
        stringBuffer.append("\n");
        stringBuffer.append("subChunk1Id: " + this.subChunk1Id);
        stringBuffer.append("\n");
        stringBuffer.append("subChunk1Size: " + this.subChunk1Size);
        stringBuffer.append("\n");
        stringBuffer.append("audioFormat: " + this.audioFormat);
        stringBuffer.append("\n");
        stringBuffer.append("channels: " + this.channels);
        stringBuffer.append("\n");
        stringBuffer.append("sampleRate: " + this.sampleRate);
        stringBuffer.append("\n");
        stringBuffer.append("byteRate: " + this.byteRate);
        stringBuffer.append("\n");
        stringBuffer.append("blockAlign: " + this.blockAlign);
        stringBuffer.append("\n");
        stringBuffer.append("bitsPerSample: " + this.bitsPerSample);
        stringBuffer.append("\n");
        stringBuffer.append("subChunk2Id: " + this.subChunk2Id);
        stringBuffer.append("\n");
        stringBuffer.append("subChunk2Size: " + this.subChunk2Size);
        return stringBuffer.toString();
    }
}

