/*
 * Decompiled with CFR 0.152.
 */
package sound.paulscode.codecs;

import java.io.BufferedInputStream;
import java.io.IOException;
import java.net.URL;
import javax.sound.sampled.AudioFormat;
import javax.sound.sampled.AudioInputStream;
import sound.javazoom.decoder.Bitstream;
import sound.javazoom.decoder.Decoder;
import sound.javazoom.decoder.Header;
import sound.javazoom.decoder.Obuffer;
import sound.javazoom.mp3spi.DecodedMpegAudioInputStream;
import sound.paulscode.ICodec;
import sound.paulscode.SoundBuffer;
import sound.paulscode.SoundSystemConfig;
import sound.paulscode.SoundSystemLogger;

public class CodecJLayerMP3
implements ICodec {
    private static final boolean GET = false;
    private static final boolean SET = true;
    private static final boolean XXX = false;
    private boolean endOfStream = false;
    private boolean initialized = false;
    private Decoder decoder;
    private Bitstream bitstream;
    private DMAISObuffer buffer;
    private Header mainHeader;
    private AudioFormat myAudioFormat = null;
    private DecodedMpegAudioInputStream myAudioInputStream = null;
    private SoundSystemLogger logger = SoundSystemConfig.getLogger();

    @Override
    public void reverseByteOrder(boolean bl) {
    }

    @Override
    public boolean initialize(URL uRL) {
        this.initialized(true, false);
        this.cleanup();
        if (uRL == null) {
            this.errorMessage("url null in method 'initialize'");
            this.cleanup();
            return false;
        }
        try {
            this.bitstream = new Bitstream(new BufferedInputStream(uRL.openStream()));
            this.decoder = new Decoder();
            this.mainHeader = this.bitstream.readFrame();
            this.buffer = new DMAISObuffer(2);
            this.decoder.setOutputBuffer(this.buffer);
            int n = this.mainHeader.mode() < 3 ? 2 : 1;
            this.bitstream.closeFrame();
            this.bitstream.close();
            this.myAudioFormat = new AudioFormat(AudioFormat.Encoding.PCM_SIGNED, this.mainHeader.frequency(), 16, n, n * 2, this.mainHeader.frequency(), false);
            AudioFormat audioFormat = new AudioFormat(AudioFormat.Encoding.PCM_SIGNED, -1.0f, 16, n, n * 2, -1.0f, false);
            this.myAudioInputStream = new DecodedMpegAudioInputStream(this.myAudioFormat, new AudioInputStream(new BufferedInputStream(uRL.openStream()), audioFormat, -1L));
        }
        catch (Exception exception) {
            this.errorMessage("Unable to set up input streams in method 'initialize'");
            this.printStackTrace(exception);
            this.cleanup();
            return false;
        }
        if (this.myAudioInputStream == null) {
            this.errorMessage("Unable to set up audio input stream in method 'initialize'");
            this.cleanup();
            return false;
        }
        this.endOfStream(true, false);
        this.initialized(true, true);
        return true;
    }

    @Override
    public boolean initialized() {
        return this.initialized(false, false);
    }

    @Override
    public SoundBuffer read() {
        int n;
        if (this.myAudioInputStream == null) {
            this.endOfStream(true, true);
            return null;
        }
        AudioFormat audioFormat = this.myAudioInputStream.getFormat();
        if (audioFormat == null) {
            this.errorMessage("Audio Format null in method 'read'");
            this.endOfStream(true, true);
            return null;
        }
        int n2 = 0;
        byte[] byArray = new byte[SoundSystemConfig.getStreamingBufferSize()];
        try {
            for (n = 0; !this.endOfStream(false, false) && n < byArray.length; n += n2) {
                this.myAudioInputStream.execute();
                n2 = this.myAudioInputStream.read(byArray, n, byArray.length - n);
                if (n2 > 0) continue;
                this.endOfStream(true, true);
                break;
            }
        }
        catch (IOException iOException) {
            this.endOfStream(true, true);
            return null;
        }
        catch (ArrayIndexOutOfBoundsException arrayIndexOutOfBoundsException) {
            arrayIndexOutOfBoundsException.printStackTrace();
            this.endOfStream(true, true);
            return null;
        }
        if (n <= 0) {
            this.endOfStream(true, true);
            return null;
        }
        SoundBuffer soundBuffer = new SoundBuffer(byArray, audioFormat);
        return soundBuffer;
    }

    @Override
    public SoundBuffer readAll() {
        int n;
        if (this.myAudioFormat == null) {
            this.errorMessage("Audio Format null in method 'readAll'");
            return null;
        }
        byte[] byArray = null;
        int n2 = this.myAudioFormat.getChannels() * (int)this.myAudioInputStream.getFrameLength() * this.myAudioFormat.getSampleSizeInBits() / 8;
        if (n2 > 0) {
            byArray = new byte[this.myAudioFormat.getChannels() * (int)this.myAudioInputStream.getFrameLength() * this.myAudioFormat.getSampleSizeInBits() / 8];
            n = 0;
            try {
                for (int i = 0; (n = this.myAudioInputStream.read(byArray, i, byArray.length - i)) != -1 && i < byArray.length; i += n) {
                }
            }
            catch (IOException iOException) {
                this.errorMessage("Exception thrown while reading from the AudioInputStream (location #1).");
                this.printStackTrace(iOException);
                return null;
            }
        }
        int n3 = 0;
        int n4 = 0;
        byte[] byArray2 = null;
        byArray2 = new byte[SoundSystemConfig.getFileChunkSize()];
        for (n = 0; !this.endOfStream(false, false) && n < SoundSystemConfig.getMaxFileSize(); n += n3) {
            n4 = 0;
            try {
                for (n3 = 0; n3 < byArray2.length; n3 += n4) {
                    this.myAudioInputStream.execute();
                    n4 = this.myAudioInputStream.read(byArray2, n3, byArray2.length - n3);
                    if (n4 > 0) continue;
                    this.endOfStream(true, true);
                    break;
                }
            }
            catch (IOException iOException) {
                this.errorMessage("Exception thrown while reading from the AudioInputStream (location #2).");
                this.printStackTrace(iOException);
                return null;
            }
            byArray = CodecJLayerMP3.appendByteArrays(byArray, byArray2, n3);
        }
        SoundBuffer soundBuffer = new SoundBuffer(byArray, this.myAudioFormat);
        try {
            this.myAudioInputStream.close();
        }
        catch (IOException iOException) {
            // empty catch block
        }
        return soundBuffer;
    }

    @Override
    public boolean endOfStream() {
        return this.endOfStream(false, false);
    }

    @Override
    public void cleanup() {
        if (this.myAudioInputStream != null) {
            try {
                this.myAudioInputStream.close();
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
    }

    @Override
    public AudioFormat getAudioFormat() {
        return this.myAudioFormat;
    }

    private synchronized boolean initialized(boolean bl, boolean bl2) {
        if (bl) {
            this.initialized = bl2;
        }
        return this.initialized;
    }

    private synchronized boolean endOfStream(boolean bl, boolean bl2) {
        if (bl) {
            this.endOfStream = bl2;
        }
        return this.endOfStream;
    }

    public static void reverseBytes(byte[] byArray) {
        CodecJLayerMP3.reverseBytes(byArray, 0, byArray.length);
    }

    public static void reverseBytes(byte[] byArray, int n, int n2) {
        for (int i = n; i < n + n2; i += 2) {
            byte by = byArray[i];
            byArray[i] = byArray[i + 1];
            byArray[i + 1] = by;
        }
    }

    private void errorMessage(String string) {
        this.logger.errorMessage("CodecJLayerMP3", string, 0);
    }

    private void printStackTrace(Exception exception) {
        this.logger.printStackTrace(exception, 1);
    }

    private static byte[] appendByteArrays(byte[] byArray, byte[] byArray2, int n) {
        byte[] byArray3;
        if (byArray == null && byArray2 == null) {
            return null;
        }
        if (byArray == null) {
            byArray3 = new byte[n];
            System.arraycopy(byArray2, 0, byArray3, 0, n);
            byArray2 = null;
        } else if (byArray2 == null) {
            byArray3 = new byte[byArray.length];
            System.arraycopy(byArray, 0, byArray3, 0, byArray.length);
            byArray = null;
        } else {
            byArray3 = new byte[byArray.length + n];
            System.arraycopy(byArray, 0, byArray3, 0, byArray.length);
            System.arraycopy(byArray2, 0, byArray3, byArray.length, n);
            byArray = null;
            byArray2 = null;
        }
        return byArray3;
    }

    private static class DMAISObuffer
    extends Obuffer {
        private int m_nChannels;
        private byte[] m_abBuffer;
        private int[] m_anBufferPointers;
        private boolean m_bIsBigEndian;

        public DMAISObuffer(int n) {
            this.m_nChannels = n;
            this.m_abBuffer = new byte[2304 * n];
            this.m_anBufferPointers = new int[n];
            this.reset();
        }

        @Override
        public void append(int n, short s) {
            byte by;
            byte by2;
            if (this.m_bIsBigEndian) {
                by2 = (byte)(s >>> 8 & 0xFF);
                by = (byte)(s & 0xFF);
            } else {
                by2 = (byte)(s & 0xFF);
                by = (byte)(s >>> 8 & 0xFF);
            }
            this.m_abBuffer[this.m_anBufferPointers[n]] = by2;
            this.m_abBuffer[this.m_anBufferPointers[n] + 1] = by;
            int n2 = n;
            this.m_anBufferPointers[n2] = this.m_anBufferPointers[n2] + this.m_nChannels * 2;
        }

        @Override
        public void set_stop_flag() {
        }

        @Override
        public void close() {
        }

        @Override
        public void write_buffer(int n) {
        }

        @Override
        public void clear_buffer() {
        }

        public void reset() {
            for (int i = 0; i < this.m_nChannels; ++i) {
                this.m_anBufferPointers[i] = i * 2;
            }
        }
    }
}

