/*
 * Decompiled with CFR 0.152.
 */
package sound.tritonus;

import java.io.ByteArrayInputStream;
import java.io.IOException;
import javax.sound.sampled.AudioFormat;
import sound.tritonus.TAudioInputStream;
import sound.tritonus.TCircularBuffer;

public abstract class TAsynchronousFilteredAudioInputStream
extends TAudioInputStream
implements TCircularBuffer.Trigger {
    private static final int DEFAULT_BUFFER_SIZE = 327670;
    private static final int DEFAULT_MIN_AVAILABLE = 4096;
    private static final byte[] EMPTY_BYTE_ARRAY = new byte[0];
    private TCircularBuffer m_circularBuffer;
    private int m_nMinAvailable;
    private byte[] m_abSingleByte;

    public TAsynchronousFilteredAudioInputStream(AudioFormat audioFormat, long l) {
        this(audioFormat, l, 327670, 4096);
    }

    public TAsynchronousFilteredAudioInputStream(AudioFormat audioFormat, long l, int n, int n2) {
        super(new ByteArrayInputStream(EMPTY_BYTE_ARRAY), audioFormat, l);
        this.m_circularBuffer = new TCircularBuffer(n, false, true, this);
        this.m_nMinAvailable = n2;
    }

    protected TCircularBuffer getCircularBuffer() {
        return this.m_circularBuffer;
    }

    protected boolean writeMore() {
        return this.getCircularBuffer().availableWrite() > this.m_nMinAvailable;
    }

    @Override
    public int read() throws IOException {
        int n;
        int n2 = -1;
        if (this.m_abSingleByte == null) {
            this.m_abSingleByte = new byte[1];
        }
        n2 = (n = this.read(this.m_abSingleByte)) == -1 ? -1 : this.m_abSingleByte[0] & 0xFF;
        return n2;
    }

    @Override
    public int read(byte[] byArray) throws IOException {
        int n = this.read(byArray, 0, byArray.length);
        return n;
    }

    @Override
    public int read(byte[] byArray, int n, int n2) throws IOException {
        int n3 = this.m_circularBuffer.read(byArray, n, n2);
        return n3;
    }

    @Override
    public long skip(long l) throws IOException {
        for (long i = 0L; i < l; ++i) {
            int n = this.read();
            if (n != -1) continue;
            return i;
        }
        return l;
    }

    @Override
    public int available() throws IOException {
        return this.m_circularBuffer.availableRead();
    }

    @Override
    public void close() throws IOException {
        this.m_circularBuffer.close();
    }

    @Override
    public boolean markSupported() {
        return false;
    }

    @Override
    public void mark(int n) {
    }

    @Override
    public void reset() throws IOException {
        throw new IOException("mark not supported");
    }
}

