/*
 * Decompiled with CFR 0.152.
 */
package sound.tritonus;

public class TCircularBuffer {
    private boolean m_bBlockingRead;
    private boolean m_bBlockingWrite;
    private byte[] m_abData;
    private int m_nSize;
    private long m_lReadPos;
    private long m_lWritePos;
    private Trigger m_trigger;
    private boolean m_bOpen;

    public TCircularBuffer(int n, boolean bl, boolean bl2, Trigger trigger) {
        this.m_bBlockingRead = bl;
        this.m_bBlockingWrite = bl2;
        this.m_nSize = n;
        this.m_abData = new byte[this.m_nSize];
        this.m_lReadPos = 0L;
        this.m_lWritePos = 0L;
        this.m_trigger = trigger;
        this.m_bOpen = true;
    }

    public void close() {
        this.m_bOpen = false;
    }

    private boolean isOpen() {
        return this.m_bOpen;
    }

    public int availableRead() {
        return (int)(this.m_lWritePos - this.m_lReadPos);
    }

    public int availableWrite() {
        return this.m_nSize - this.availableRead();
    }

    private int getReadPos() {
        return (int)(this.m_lReadPos % (long)this.m_nSize);
    }

    private int getWritePos() {
        return (int)(this.m_lWritePos % (long)this.m_nSize);
    }

    public int read(byte[] byArray) {
        return this.read(byArray, 0, byArray.length);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int read(byte[] byArray, int n, int n2) {
        if (!this.isOpen()) {
            if (this.availableRead() > 0) {
                n2 = Math.min(n2, this.availableRead());
            } else {
                return -1;
            }
        }
        TCircularBuffer tCircularBuffer = this;
        synchronized (tCircularBuffer) {
            if (this.m_trigger != null && this.availableRead() < n2) {
                this.m_trigger.execute();
            }
            if (!this.m_bBlockingRead) {
                n2 = Math.min(this.availableRead(), n2);
            }
            int n3 = n2;
            while (n3 > 0) {
                while (this.availableRead() == 0) {
                    try {
                        this.wait();
                    }
                    catch (InterruptedException interruptedException) {}
                }
                int n4 = Math.min(this.availableRead(), n3);
                while (n4 > 0) {
                    int n5 = Math.min(n4, this.m_nSize - this.getReadPos());
                    System.arraycopy(this.m_abData, this.getReadPos(), byArray, n, n5);
                    this.m_lReadPos += (long)n5;
                    n += n5;
                    n4 -= n5;
                    n3 -= n5;
                }
                this.notifyAll();
            }
            return n2;
        }
    }

    public int write(byte[] byArray) {
        return this.write(byArray, 0, byArray.length);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int write(byte[] byArray, int n, int n2) {
        TCircularBuffer tCircularBuffer = this;
        synchronized (tCircularBuffer) {
            if (!this.m_bBlockingWrite) {
                n2 = Math.min(this.availableWrite(), n2);
            }
            int n3 = n2;
            while (n3 > 0) {
                while (this.availableWrite() == 0) {
                    try {
                        this.wait();
                    }
                    catch (InterruptedException interruptedException) {}
                }
                int n4 = Math.min(this.availableWrite(), n3);
                while (n4 > 0) {
                    int n5 = Math.min(n4, this.m_nSize - this.getWritePos());
                    System.arraycopy(byArray, n, this.m_abData, this.getWritePos(), n5);
                    this.m_lWritePos += (long)n5;
                    n += n5;
                    n4 -= n5;
                    n3 -= n5;
                }
                this.notifyAll();
            }
            return n2;
        }
    }

    public static interface Trigger {
        public void execute();
    }
}

