/*
 * Decompiled with CFR 0.152.
 */
package br.com.abby;

import br.com.abby.linear.Box3D;
import br.com.abby.linear.Point3D;
import br.com.abby.linear.Polygon3D;
import br.com.abby.material.Texture;
import br.com.abby.util.CameraGL;
import br.com.abby.util.Lamp;
import org.jgl.GLAUX;

public abstract class Application3D
extends GLAUX {
    public Application3D(int n, int n2) {
        super(n, n2);
    }

    protected void desenhaPoligono(Polygon3D polygon3D) {
        this.glPushMatrix();
        this.glLoadIdentity();
        this.glColor3d(polygon3D.getColor().getRed() / 255, polygon3D.getColor().getGreen() / 255, polygon3D.getColor().getBlue() / 255);
        this.glTranslated(polygon3D.getX(), polygon3D.getY(), polygon3D.getZ());
        this.glRotated(polygon3D.getAngleX(), 1.0, 0.0, 0.0);
        this.glRotated(polygon3D.getAngleY(), 0.0, 1.0, 0.0);
        this.glRotated(polygon3D.getAngleZ(), 0.0, 0.0, 1.0);
        this.glBegin(8);
        for (int i = 0; i < polygon3D.getVertices().size(); ++i) {
            double d = polygon3D.getVertices().get(i).getX();
            double d2 = polygon3D.getVertices().get(i).getY();
            double d3 = polygon3D.getVertices().get(i).getZ();
            this.glVertex3d(d, d2, d3);
        }
        this.glEnd();
        this.glPopMatrix();
    }

    protected void desenhaCaixa(Box3D box3D) {
        this.glPushMatrix();
        this.glColor3d(box3D.getColor().getRed() / 255, box3D.getColor().getGreen() / 255, box3D.getColor().getBlue() / 255);
        this.glTranslated(box3D.getX(), box3D.getY(), box3D.getZ());
        this.glRotated(box3D.getAngleZ(), 0.0, 0.0, 1.0);
        this.glRotated(box3D.getAngleY(), 0.0, 1.0, 0.0);
        this.auxSolidBox(box3D.getAltura(), box3D.getLargura(), box3D.getProfundidade());
        this.glPopMatrix();
    }

    protected void setLamp(Lamp lamp) {
        float[] fArray = new float[]{(float)lamp.getX(), (float)lamp.getY(), (float)lamp.getZ(), 0.0f};
        this.glLightfv(16384, 4611, fArray);
        this.glEnable(2896);
        this.glEnable(16384);
        this.glColorMaterial(1028, 4609);
        this.glEnable(2903);
    }

    protected void lookatCamera(CameraGL cameraGL) {
        Point3D point3D = cameraGL.getTarget();
        this.gluLookAt(cameraGL.getX(), cameraGL.getY(), cameraGL.getZ(), point3D.getX(), point3D.getY(), point3D.getZ(), 0.0, 0.0, 1.0);
    }

    protected void enableTextureDefault() {
        this.glShadeModel(7424);
        this.glTexEnvf(8960, 8704, 8448.0f);
        this.glTexParameteri(3553, 10240, 9729);
        this.glTexParameteri(3553, 10241, 9729);
        this.glTexParameteri(3553, 10242, 10497);
        this.glTexParameteri(3553, 10243, 10497);
        this.glEnable(2929);
        this.glDepthFunc(513);
        this.glEnable(3553);
        this.glEnable(2884);
        this.glCullFace(1029);
    }

    protected void enableTextureNoRepeat() {
    }

    protected void setTexture(Texture texture) {
        this.glTexImage2D(3553, 0, 6407, texture.getW(), texture.getH(), 0, 6407, 5121, texture.getBytes());
    }

    protected void setAlphaTexture(Texture texture) {
        this.glTexImage2D(3553, 0, 6408, texture.getW(), texture.getH(), 0, 6408, 5121, texture.getAlphaBytes());
        this.glEnable(3042);
        this.glBlendFunc(770, 771);
    }

    protected int[] getViewPort() {
        int[] nArray = new int[4];
        this.glGetIntegerv(2978, nArray);
        return nArray;
    }

    protected double[] getModelView() {
        double[] dArray = new double[16];
        this.glGetDoublev(2982, dArray);
        return dArray;
    }

    protected double[] getProjection() {
        double[] dArray = new double[16];
        this.glGetDoublev(2983, dArray);
        return dArray;
    }
}

