/*
 * Decompiled with CFR 0.152.
 */
package br.com.etyllica.animation.timeline;

import br.com.etyllica.animation.timeline.KeyFrame;
import java.util.ArrayList;
import java.util.List;

public abstract class Timeline<T> {
    protected int cursor = 0;
    protected List<KeyFrame<T>> frames = new ArrayList<KeyFrame<T>>();

    public void nextFrame() {
        if (this.cursor < this.frames.size() - 1) {
            ++this.cursor;
            this.reloadFrame(this.currentFrame());
        }
    }

    public void previousFrame() {
        if (this.cursor > 0) {
            --this.cursor;
            this.reloadFrame(this.currentFrame());
        }
    }

    public KeyFrame<T> currentFrame() {
        return this.frames.get(this.cursor);
    }

    public int frameCount() {
        return this.frames.size();
    }

    public int getCursor() {
        return this.cursor;
    }

    public abstract void reloadFrame(KeyFrame<T> var1);
}

