/*
 * Decompiled with CFR 0.152.
 */
package br.com.etyllica.core;

import br.com.etyllica.animation.AnimationHandler;
import br.com.etyllica.animation.scripts.AnimationScript;
import br.com.etyllica.animation.scripts.SingleIntervalAnimation;
import br.com.etyllica.context.Application;
import br.com.etyllica.context.Context;
import br.com.etyllica.core.Configuration;
import br.com.etyllica.core.Core;
import br.com.etyllica.core.Updatable;
import br.com.etyllica.core.drawer.ArrowDrawer;
import br.com.etyllica.core.event.GUIEvent;
import br.com.etyllica.core.event.KeyEvent;
import br.com.etyllica.core.event.PointerEvent;
import br.com.etyllica.core.event.PointerState;
import br.com.etyllica.core.graphics.Graphic;
import br.com.etyllica.core.input.HIDController;
import br.com.etyllica.core.input.InputKeyListener;
import br.com.etyllica.core.input.keyboard.Keyboard;
import br.com.etyllica.core.input.mouse.Mouse;
import br.com.etyllica.core.input.mouse.MouseButton;
import br.com.etyllica.debug.Logger;
import br.com.etyllica.effects.GlobalEffect;
import br.com.etyllica.gui.View;
import br.com.etyllica.gui.Window;
import br.com.etyllica.i18n.Language;
import br.com.etyllica.i18n.LanguageChangerListener;
import br.com.etyllica.i18n.LanguageHandler;
import br.com.etyllica.theme.Theme;
import br.com.etyllica.theme.ThemeManager;
import br.com.etyllica.theme.dalt.DaltArrowTheme;
import br.com.etyllica.theme.listener.ThemeListener;
import java.awt.Color;
import java.util.ArrayList;
import java.util.List;
import java.util.concurrent.CopyOnWriteArrayList;

public class InnerCore
implements Core,
InputKeyListener,
Updatable,
ThemeListener,
LanguageChangerListener {
    private Window activeWindow = null;
    private View focus;
    protected HIDController control;
    protected Mouse mouse;
    protected Keyboard keyboard;
    protected View mouseOver = null;
    protected View focusComponent = null;
    private List<GUIEvent> guiEvents;
    private Window mainWindow;
    private boolean drawCursor = true;
    protected boolean fullScreenEnable = false;
    private boolean needReload = false;
    private boolean locked = false;
    private Configuration configuration = Configuration.getInstance();
    private int fps = 0;
    private boolean enableFullScreen = false;
    private boolean disableFullScreen = false;
    private boolean alt = false;
    private boolean enter = false;
    private boolean esc = false;
    protected GUIEvent superEvent = GUIEvent.NONE;
    private ArrowDrawer arrowDrawer;
    private LanguageHandler languageHandler;
    private List<Updatable> updatables = new ArrayList<Updatable>();
    private List<SingleIntervalAnimation> globalScripts = new ArrayList<SingleIntervalAnimation>();

    public InnerCore() {
        this.guiEvents = new ArrayList<GUIEvent>();
        this.control = new HIDController(this);
        this.mouse = this.control.getMouse();
        this.keyboard = this.control.getKeyboard();
        this.arrowDrawer = new ArrowDrawer();
        this.languageHandler = new LanguageHandler();
        this.initTheme();
        this.updatables.add(AnimationHandler.getInstance());
    }

    private void initTheme() {
        ThemeManager.getInstance().setThemeListener(this);
        ThemeManager.getInstance().setArrowThemeListener(this.arrowDrawer);
        ThemeManager.getInstance().setArrowTheme(new DaltArrowTheme());
    }

    public Window getWindow() {
        return this.mainWindow;
    }

    @Override
    public void update(long l) {
        if (!this.activeWindow.isLoaded()) {
            return;
        }
        if (this.needReload) {
            this.fastReload();
        }
        this.superEvent = GUIEvent.NONE;
        this.updateActiveWindow(l);
        this.updateEffects(l);
        Context context = this.activeWindow.getContext();
        this.updateApplication(context, l);
        CopyOnWriteArrayList<View> copyOnWriteArrayList = new CopyOnWriteArrayList<View>(context.getViews());
        this.updateGui(copyOnWriteArrayList, this.guiEvents);
        this.mouse.lock();
        List<PointerEvent> list = this.mouse.getEvents();
        this.updatePointerEvents(list, context, copyOnWriteArrayList);
        this.mouse.packEvents();
        this.mouse.unlock();
        this.updateHelperUI(l);
        this.keyboard.update(l);
        this.handleFullScreen();
    }

    private void handleFullScreen() {
        if (this.enableFullScreen) {
            this.enableFullScreen = false;
            this.superEvent = GUIEvent.ENABLE_FULL_SCREEN;
        }
        if (this.disableFullScreen) {
            this.disableFullScreen = false;
            this.superEvent = GUIEvent.DISABLE_FULL_SCREEN;
        }
    }

    public void resizeApplication(int n, int n2) {
        Context context = this.activeWindow.getContext();
        context.resize(n, n2);
        context.setW(n);
        context.setH(n2);
    }

    public boolean updateApplication(Context context, long l) {
        if (context.isLocked()) {
            return false;
        }
        if (context.getUpdateInterval() == 0) {
            context.update(l);
            context.setLastUpdate(l);
            context.getScene().update(l);
        } else if (l - context.getLastUpdate() >= (long)context.getUpdateInterval()) {
            context.timeUpdate(l);
            context.setLastUpdate(l);
            context.getScene().update(l);
        }
        if (context.getNextApplication() != context) {
            this.changeApplication();
        }
        return true;
    }

    private void updateActiveWindow(long l) {
        List<Window> list = this.activeWindow.getWindows();
        if (!list.isEmpty()) {
            for (Window window : list) {
                this.replaceWindow(window);
            }
            this.activeWindow.getWindows().clear();
        }
    }

    @Override
    public void updateJoystickEvent(KeyEvent keyEvent) {
        System.out.println("UpdateJoystick " + keyEvent.getKey());
        this.activeWindow.getContext().updateKeyboard(keyEvent);
    }

    public void updatePointerEvents(List<PointerEvent> list, Context context, List<View> list2) {
        int n = list.size();
        for (int i = 0; i < n; ++i) {
            PointerEvent pointerEvent = list.get(i);
            context.updateMouse(pointerEvent);
            this.updatePointerEvent(pointerEvent, list2);
        }
    }

    public void updatePointerEvent(PointerEvent pointerEvent, List<View> list) {
        this.fixEventPosition(pointerEvent);
        this.updateMouseComponents(pointerEvent, list);
        this.updateWindowEvent(pointerEvent, this.activeWindow);
    }

    private void updateMouseComponents(PointerEvent pointerEvent, List<View> list) {
        for (View view : list) {
            GUIEvent gUIEvent = this.updateMouse(view, pointerEvent);
            if (gUIEvent == GUIEvent.NONE) continue;
            View view2 = view.findNext();
            if (view2 == null) break;
            this.focusComponent = view2;
            if (gUIEvent == GUIEvent.NEXT_COMPONENT) {
                this.updateEvent(this.focusComponent, GUIEvent.GAIN_FOCUS);
                break;
            }
            this.updateEvent(this.focusComponent, gUIEvent);
            break;
        }
    }

    private void updateWindowEvent(PointerEvent pointerEvent, Window window) {
        GUIEvent gUIEvent = this.updateFrameEvents(pointerEvent);
        if (gUIEvent != GUIEvent.NONE) {
            this.superEvent = gUIEvent;
        }
    }

    private void updateGui(List<View> list, List<GUIEvent> list2) {
        for (GUIEvent gUIEvent : list2) {
            this.updateGuiEvent(list, gUIEvent);
        }
        list2.clear();
    }

    private void updateGuiEvent(List<View> list, GUIEvent gUIEvent) {
        for (View view : list) {
            this.updateGuiComponent(view, gUIEvent);
        }
    }

    private void updateGuiComponent(View view, GUIEvent gUIEvent) {
        view.update(gUIEvent);
        for (View view2 : view.getViews()) {
            this.updateGuiComponent(view2, gUIEvent);
        }
    }

    private GUIEvent updateMouse(View view, PointerEvent pointerEvent) {
        if (!view.isVisible()) {
            return GUIEvent.NONE;
        }
        if (view.onMouse(pointerEvent)) {
            if (view != this.mouseOver) {
                this.setMouseOver(view);
                return GUIEvent.NONE;
            }
            GUIEvent gUIEvent = view.updateMouse(pointerEvent);
            if (gUIEvent != GUIEvent.NONE && gUIEvent != null) {
                this.updateEvent(view, gUIEvent);
            }
        } else if (view == this.mouseOver) {
            this.resetMouseOver();
        }
        return GUIEvent.NONE;
    }

    private void updateEvent(View view, GUIEvent gUIEvent) {
        switch (gUIEvent) {
            case GAIN_FOCUS: {
                if (this.focus != null) {
                    this.focus.update(GUIEvent.LOST_FOCUS);
                }
                view.setOnFocus(true);
                this.focus = view;
                break;
            }
            case LOST_FOCUS: {
                if (view != this.focus) break;
                this.focus = null;
                break;
            }
            case MOUSE_OVER_WITH_FOCUS: {
                break;
            }
            case NEXT_COMPONENT: {
                Logger.log("LostFocus");
                view.update(GUIEvent.LOST_FOCUS);
                break;
            }
            case WINDOW_CLOSE: {
                break;
            }
            case UPDATE_MOUSE: {
                this.updateMouse(view, new PointerEvent(MouseButton.MOUSE_NONE, PointerState.MOVE, this.mouse.getX(), this.mouse.getY()));
                break;
            }
            case APPLICATION_CHANGED: {
                this.changeApplication();
                break;
            }
            default: {
                if (!view.isMouseOver()) break;
                view.update(GUIEvent.MOUSE_OUT);
            }
        }
        view.setLastEvent(gUIEvent);
        view.update(gUIEvent);
        view.executeAction(gUIEvent);
    }

    public void draw(Graphic graphic) {
        if (!this.canDraw()) {
            return;
        }
        this.drawContext(this.activeWindow.getContext(), graphic);
        this.drawGlobalEffects(graphic);
        if (this.drawCursor) {
            this.arrowDrawer.setCoordinates(this.mouse.getX(), this.mouse.getY());
            this.arrowDrawer.draw(graphic);
        }
    }

    protected boolean canDraw() {
        return !this.locked && !this.needReload;
    }

    private void drawContext(Context context, Graphic graphic) {
        if (context.isClearBeforeDraw()) {
            graphic.setColor(Color.WHITE);
            graphic.fillRect(0, 0, context.getW(), context.getH());
        }
        context.drawContext(graphic);
        for (View view : context.getViews()) {
            this.drawView(view, graphic);
        }
    }

    private void updateEffects(long l) {
        for (Updatable updatable : this.updatables) {
            updatable.update(l);
        }
    }

    private void drawGlobalEffects(Graphic graphic) {
        ArrayList<SingleIntervalAnimation> arrayList = new ArrayList<SingleIntervalAnimation>();
        for (AnimationScript animationScript : this.globalScripts) {
            if (!animationScript.isStopped()) {
                animationScript.getTarget().draw(graphic);
                continue;
            }
            arrayList.add((SingleIntervalAnimation)animationScript);
        }
        for (AnimationScript animationScript : arrayList) {
            this.globalScripts.remove(animationScript);
        }
    }

    private void drawView(View view, Graphic graphic) {
        view.draw(graphic);
        if (!view.getViews().isEmpty()) {
            CopyOnWriteArrayList<View> copyOnWriteArrayList = new CopyOnWriteArrayList<View>(view.getViews());
            for (View view2 : copyOnWriteArrayList) {
                view2.setOffset(view.getX(), view.getY());
                this.drawView(view2, graphic);
                view2.setOffset(-view.getX(), -view.getY());
            }
        }
    }

    public boolean isMouseOver() {
        return this.mouseOver != null;
    }

    public View getMouseOver() {
        return this.mouseOver;
    }

    public void addEffect(GlobalEffect globalEffect) {
        AnimationHandler.getInstance().add(globalEffect.getScript());
        this.globalScripts.add(globalEffect.getScript());
    }

    private void updateKeyboardEvents(KeyEvent keyEvent) {
        if (keyEvent.isKeyDown(318) || keyEvent.isKeyDown(218)) {
            this.alt = true;
        } else if (keyEvent.isKeyUp(318) || keyEvent.isKeyUp(218)) {
            this.alt = false;
        }
        if (keyEvent.isKeyDown(10)) {
            this.enter = true;
        } else if (keyEvent.isKeyUp(10)) {
            this.enter = false;
        }
        if (keyEvent.isKeyDown(27)) {
            this.esc = true;
        } else if (keyEvent.isKeyUp(27)) {
            this.esc = false;
        }
        if (this.alt && this.enter) {
            this.alt = false;
            this.enter = false;
            if (!this.fullScreenEnable) {
                this.enableFullScreen = true;
            }
        }
        if (this.esc) {
            this.esc = false;
            if (this.fullScreenEnable) {
                this.disableFullScreen = true;
            }
        }
    }

    private void updateNumpadMouse(KeyEvent keyEvent) {
        if (Configuration.getInstance().isNumpadMouse()) {
            int n = 1;
            if (keyEvent.isKeyDown(626)) {
                this.mouse.setX(this.mouse.getX() - n);
                this.mouse.addEvent(new PointerEvent(MouseButton.MOUSE_NONE, PointerState.MOVE, this.mouse.getX(), this.mouse.getY()));
            } else if (keyEvent.isKeyDown(627)) {
                this.mouse.setX(this.mouse.getX() + n);
                this.mouse.addEvent(new PointerEvent(MouseButton.MOUSE_NONE, PointerState.MOVE, this.mouse.getX(), this.mouse.getY()));
            }
            if (keyEvent.isKeyDown(624)) {
                this.mouse.setX(this.mouse.getY() - n);
                this.mouse.addEvent(new PointerEvent(MouseButton.MOUSE_NONE, PointerState.MOVE, this.mouse.getX(), this.mouse.getY()));
            } else if (keyEvent.isKeyDown(625)) {
                this.mouse.setX(this.mouse.getY() + n);
                this.mouse.addEvent(new PointerEvent(MouseButton.MOUSE_NONE, PointerState.MOVE, this.mouse.getX(), this.mouse.getY()));
            }
            if (keyEvent.isKeyDown(555)) {
                this.mouse.addEvent(new PointerEvent(MouseButton.MOUSE_BUTTON_LEFT, PointerState.PRESSED));
            } else if (keyEvent.isKeyUp(555)) {
                this.mouse.addEvent(new PointerEvent(MouseButton.MOUSE_BUTTON_LEFT, PointerState.RELEASED));
            }
            if (keyEvent.isKeyDown(508)) {
                this.mouse.addEvent(new PointerEvent(MouseButton.MOUSE_BUTTON_RIGHT, PointerState.PRESSED));
            } else if (keyEvent.isKeyUp(508)) {
                this.mouse.addEvent(new PointerEvent(MouseButton.MOUSE_BUTTON_RIGHT, PointerState.RELEASED));
            }
        }
    }

    private GUIEvent updateFrameEvents(PointerEvent pointerEvent) {
        if (pointerEvent.getState() == PointerState.CLICK) {
            return GUIEvent.REQUEST_FOCUS;
        }
        if (pointerEvent.getState() == PointerState.DRAGGED && this.mouse.getY() <= 50) {
            return GUIEvent.WINDOW_MOVE;
        }
        return GUIEvent.NONE;
    }

    public void replaceWindow(Window window) {
        if (this.activeWindow != window) {
            window.setClose(false);
            this.activeWindow = window;
            this.reload(window.getContext());
        }
    }

    public void setMainApplication(Application application) {
        this.reload(application);
    }

    protected void changeApplication() {
        this.reload(this.activeWindow.getContext().getNextApplication());
    }

    private void reload(Context context) {
        if (context == null) {
            System.err.println("Application cannot be null.");
        }
        context.setSession(this.activeWindow.getSession());
        context.setCamera(this.activeWindow.getCamera());
        context.setMouseStateListener(this.arrowDrawer);
        context.setLanguageChangerListener(this);
        this.activeWindow.reload(context);
    }

    private void fastReload() {
        this.locked = true;
        this.activeWindow.getContext().clearComponents();
        this.activeWindow.getContext().load();
        this.needReload = false;
        this.locked = false;
    }

    private void updateHelperUI(long l) {
        this.updateTimerClick(l);
    }

    private void updateTimerClick(long l) {
        if (this.mouseOver != null) {
            if (this.configuration.isTimerClick()) {
                int n = this.arrowDrawer.getArc();
                if (n < 360) {
                    this.arrowDrawer.setArc(n + 3);
                } else {
                    this.updateEvent(this.mouseOver, GUIEvent.MOUSE_LEFT_BUTTON_DOWN);
                    this.updateEvent(this.mouseOver, GUIEvent.MOUSE_LEFT_BUTTON_UP);
                    this.resetMouseOver();
                }
            }
        } else if (this.configuration.isTimerClick()) {
            this.arrowDrawer.setArc(0);
        }
    }

    @Override
    public void updateKeyEvent(KeyEvent keyEvent) {
        GUIEvent gUIEvent;
        this.activeWindow.getContext().updateKeyboard(keyEvent);
        if (this.focus != null && (gUIEvent = this.focus.updateKeyboard(keyEvent)) != GUIEvent.NONE && gUIEvent != null) {
            Logger.log((Object)gUIEvent);
            View view = this.focus.findNext();
            if (view != null) {
                if (gUIEvent == GUIEvent.NEXT_COMPONENT) {
                    this.updateEvent(this.focus, gUIEvent);
                    this.updateEvent(view, GUIEvent.GAIN_FOCUS);
                } else {
                    this.updateEvent(view, gUIEvent);
                }
            }
        }
        this.updateKeyboardEvents(keyEvent);
        this.updateNumpadMouse(keyEvent);
    }

    private void fixEventPosition(PointerEvent pointerEvent) {
        pointerEvent.setX(pointerEvent.getX() - this.activeWindow.getX());
        pointerEvent.setY(pointerEvent.getY() - this.activeWindow.getY());
    }

    private void setMouseOver(View view) {
        if (this.mouseOver != null) {
            this.removeMouseOver(this.mouseOver);
        }
        this.mouseOver = view;
        this.mouseOver.setMouseOver(true);
        this.mouseOver.update(GUIEvent.MOUSE_IN);
        this.arrowDrawer.setOverClickable(true);
    }

    private void resetMouseOver() {
        this.removeMouseOver(this.mouseOver);
        this.mouseOver = null;
        this.arrowDrawer.setOverClickable(false);
    }

    private void removeMouseOver(View view) {
        view.setMouseOver(false);
        view.update(GUIEvent.MOUSE_OUT);
    }

    public HIDController getControl() {
        return this.control;
    }

    public GUIEvent getSuperEvent() {
        return this.superEvent;
    }

    public void hideCursor() {
        this.drawCursor = false;
    }

    public void showCursor() {
        this.drawCursor = true;
    }

    public int getFps() {
        return this.fps;
    }

    public void setFps(int n) {
        this.fps = n;
        this.activeWindow.getContext().setFps(n);
    }

    @Override
    public void updateTheme(Theme theme) {
        this.needReload = true;
    }

    @Override
    public void changeLanguage(Language language) {
        this.languageHandler.changeLanguage(language);
        CopyOnWriteArrayList<View> copyOnWriteArrayList = new CopyOnWriteArrayList<View>(this.activeWindow.getContext().getViews());
        this.updateGuiEvent(copyOnWriteArrayList, GUIEvent.LANGUAGE_CHANGED);
    }
}

