/*
 * Decompiled with CFR 0.152.
 */
package br.com.etyllica.core.graphics;

import br.com.etyllica.core.InnerCore;
import br.com.etyllica.core.graphics.Monitor;
import br.com.etyllica.core.input.keyboard.Keyboard;
import br.com.etyllica.core.input.mouse.Mouse;
import java.awt.Cursor;
import java.awt.Frame;
import java.awt.Graphics2D;
import java.awt.Image;
import java.awt.Point;
import java.awt.RenderingHints;
import java.awt.Toolkit;
import java.awt.Window;
import java.awt.image.BufferedImage;
import java.awt.image.MemoryImageSource;

public class FullScreenWindow
extends Window {
    private static final long serialVersionUID = -5176767672500250086L;
    private InnerCore core;
    private int w;
    private int h;
    private int utilHeight;
    private int offsetY = 0;

    public FullScreenWindow(InnerCore innerCore, Monitor monitor) {
        super(new Frame());
        this.core = innerCore;
        this.setBounds(monitor.getX(), monitor.getY(), monitor.getW(), monitor.getH());
        this.w = monitor.getW();
        this.h = monitor.getH();
        int n = this.w / 16;
        this.utilHeight = 9 * n;
        this.offsetY = (this.h - this.utilHeight) / 2;
        this.hideDefaultCursor();
        this.setVisible(true);
        this.setAlwaysOnTop(true);
        this.setListeners();
    }

    private void setListeners() {
        Mouse mouse = this.core.getControl().getMouse();
        Keyboard keyboard = this.core.getControl().getKeyboard();
        this.addMouseMotionListener(mouse);
        this.addMouseWheelListener(mouse);
        this.addMouseListener(mouse);
        this.addKeyListener(keyboard);
    }

    public void draw(Image image) {
        int n = this.offsetY;
        BufferedImage bufferedImage = new BufferedImage(this.w, this.h, 1);
        Graphics2D graphics2D = bufferedImage.createGraphics();
        graphics2D.setRenderingHint(RenderingHints.KEY_INTERPOLATION, RenderingHints.VALUE_INTERPOLATION_NEAREST_NEIGHBOR);
        graphics2D.drawImage(image, 0, n, this.w, this.h, 0, 0, image.getWidth(null), n + image.getHeight(null), null);
        graphics2D.dispose();
        this.getGraphics().drawImage(bufferedImage, 0, 0, null);
    }

    private void hideDefaultCursor() {
        int[] nArray = new int[256];
        Cursor cursor = Toolkit.getDefaultToolkit().createCustomCursor(Toolkit.getDefaultToolkit().createImage(new MemoryImageSource(16, 16, nArray, 0, 16)), new Point(0, 0), "invisibleCursor");
        this.setCursor(cursor);
        this.core.showCursor();
    }
}

