/*
 * Decompiled with CFR 0.152.
 */
package br.com.etyllica.core.loader;

import br.com.etyllica.core.loader.LoaderImpl;
import java.awt.Font;
import java.awt.FontFormatException;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.HashMap;
import java.util.Map;

public class FontLoader
extends LoaderImpl {
    private static FontLoader instance = null;
    private String[] systemFonts;
    private Map<String, Font> fonts = new HashMap<String, Font>();

    private FontLoader() {
        this.folder = "assets/fonts/";
    }

    public static FontLoader getInstance() {
        if (instance == null) {
            instance = new FontLoader();
        }
        return instance;
    }

    public Font getFont(String string, float f) {
        Font font = this.loadFont(string);
        return font.deriveFont(f);
    }

    public Font loadFont(String string) {
        if (!this.fonts.containsKey(string)) {
            String string2 = this.folder + string;
            URL uRL = null;
            try {
                uRL = new URL(this.url, string2);
            }
            catch (MalformedURLException malformedURLException) {
                malformedURLException.printStackTrace();
            }
            try {
                Font font = Font.createFont(0, uRL.openStream());
                this.fonts.put(string, font);
            }
            catch (FileNotFoundException fileNotFoundException) {
                fileNotFoundException.printStackTrace();
            }
            catch (FontFormatException fontFormatException) {
                fontFormatException.printStackTrace();
            }
            catch (IOException iOException) {
                iOException.printStackTrace();
            }
        }
        return this.fonts.get(string);
    }

    public String[] getSystemFonts() {
        return this.systemFonts;
    }

    public void setSystemFonts(String[] stringArray) {
        this.systemFonts = stringArray;
    }
}

