/*
 * Decompiled with CFR 0.152.
 */
package br.com.etyllica.effects.light;

import br.com.etyllica.core.graphics.Graphic;
import br.com.etyllica.effects.light.LightSpot;
import br.com.etyllica.layer.BufferedLayer;
import java.awt.AlphaComposite;
import java.awt.Color;

public class ShadowLayer
extends BufferedLayer {
    private Color color = Color.BLACK;

    public ShadowLayer(int n, int n2, int n3, int n4) {
        super(n, n2, n3, n4);
    }

    public void drawLights(Graphic graphic, LightSpot ... lightSpotArray) {
        this.refresh();
        this.setColor(this.color);
        graphic.setImage(this.buffer);
        graphic.setComposite(AlphaComposite.getInstance(5, 1.0f));
        for (LightSpot lightSpot : lightSpotArray) {
            lightSpot.drawLight(graphic);
        }
        graphic.resetOpacity();
        graphic.resetImage();
        graphic.drawImage(this.buffer, this.x, this.y);
    }

    public void setColor(Color color) {
        this.color = color;
        this.clearGraphics();
        this.graphics.setColor(color);
        this.graphics.fillRect(this.x, this.y, this.w, this.h);
    }
}

