/*
 * Decompiled with CFR 0.152.
 */
package br.com.etyllica.gui;

import br.com.etyllica.core.event.Action;
import br.com.etyllica.core.event.GUIEvent;
import br.com.etyllica.core.event.KeyEvent;
import br.com.etyllica.core.event.PointerEvent;
import br.com.etyllica.core.graphics.Graphic;
import br.com.etyllica.gui.View;
import br.com.etyllica.gui.factory.DefaultButton;
import br.com.etyllica.gui.icon.DownArrow;
import br.com.etyllica.gui.list.Option;
import java.awt.Color;
import java.util.ArrayList;
import java.util.List;

public class Select
extends View {
    private List<Option> options = new ArrayList<Option>();
    private DefaultButton button;
    private int selectedOption = 0;
    private boolean showOptions = false;

    public Select(int n, int n2, int n3, int n4) {
        super(n, n2, n3, n4);
        int n5 = n4;
        this.button = new DefaultButton(n3 - n5, 0, n5, n5);
        DownArrow downArrow = new DownArrow(n + n5 / 4, n2 + n5 / 5, (float)(n5 / 2));
        this.button.setLabel(downArrow);
        this.button.addAction(GUIEvent.MOUSE_LEFT_BUTTON_UP, new Action(this, "swapShowOptions"));
        this.add(this.button);
    }

    public void swapShowOptions() {
        this.showOptions = !this.showOptions;
    }

    public void addOption(Option option) {
        this.options.add(option);
    }

    @Override
    public void update(GUIEvent gUIEvent) {
    }

    @Override
    public void draw(Graphic graphic) {
        graphic.setColor(Color.BLACK);
        graphic.drawRect(this.x, this.y, this.w, this.h);
        int n = graphic.getFont().getSize() + 1;
        int n2 = 2;
        graphic.write(this.x + n2, this.y + n, this.options.get(this.selectedOption).getLabel());
        if (this.showOptions) {
            float f = this.y + this.h;
            float f2 = this.h * (this.options.size() + 1);
            graphic.setColor(Color.WHITE);
            graphic.fillRect((float)this.x, f, (float)this.w, f2);
            graphic.setColor(Color.BLACK);
            int n3 = 0;
            for (Option option : this.options) {
                graphic.write(this.x + n2, this.y + this.h * (2 + n3), option.getLabel());
                ++n3;
            }
            graphic.setColor(Color.BLACK);
            graphic.drawRect((double)this.x, f, (double)this.w, f2);
        }
    }

    @Override
    public GUIEvent updateMouse(PointerEvent pointerEvent) {
        return GUIEvent.NONE;
    }

    @Override
    public GUIEvent updateKeyboard(KeyEvent keyEvent) {
        return GUIEvent.NONE;
    }
}

