/*
 * Decompiled with CFR 0.152.
 */
package br.com.etyllica.gui;

import br.com.etyllica.core.event.Action;
import br.com.etyllica.core.event.GUIEvent;
import br.com.etyllica.core.event.KeyEvent;
import br.com.etyllica.core.event.PointerEvent;
import br.com.etyllica.core.graphics.Graphic;
import br.com.etyllica.gui.Panel;
import br.com.etyllica.gui.View;
import br.com.etyllica.gui.factory.DefaultButton;
import br.com.etyllica.gui.label.TextLabel;

public abstract class Spinner<T extends Number>
extends View {
    private DefaultButton plus;
    private DefaultButton minus;
    private TextLabel resultLabel;
    private Panel resultPanel;
    protected T value;
    protected T step;
    protected T maxValue;
    protected T minValue;

    public Spinner(int n, int n2, int n3, int n4) {
        this.resultPanel = new Panel(n, n2, n3, n4);
        this.add(this.resultPanel);
        this.resultLabel = new TextLabel(n + 10, n2 + 2 + n4 / 2, "0");
        this.add(this.resultLabel);
        int n5 = n3 / 6;
        int n6 = 1;
        this.plus = new DefaultButton(n + n3 - n5 - n6, n2 + n6, n5, n4 / 2 - n6 - 1);
        this.plus.setLabel(new TextLabel("+"));
        this.plus.addAction(GUIEvent.MOUSE_LEFT_BUTTON_UP, new Action(this, "addReload"));
        this.add(this.plus);
        this.minus = new DefaultButton(n + n3 - n5 - n6, n2 + n4 / 2 + n6, n5, n4 / 2 - n6);
        this.minus.setLabel(new TextLabel("-"));
        this.minus.addAction(GUIEvent.MOUSE_LEFT_BUTTON_UP, new Action(this, "subReload"));
        this.add(this.minus);
    }

    public void addReload() {
        this.add();
        this.reload();
    }

    public void subReload() {
        this.subtract();
        this.reload();
    }

    private void reload() {
        this.resultLabel.setText(this.value.toString());
    }

    public abstract void add();

    public abstract void subtract();

    @Override
    public GUIEvent updateMouse(PointerEvent pointerEvent) {
        return GUIEvent.NONE;
    }

    @Override
    public GUIEvent updateKeyboard(KeyEvent keyEvent) {
        return GUIEvent.NONE;
    }

    @Override
    public void update(GUIEvent gUIEvent) {
    }

    @Override
    public void draw(Graphic graphic) {
    }

    public void setValue(T t) {
        this.value = t;
        this.resultLabel.setText(t.toString());
    }

    public T getValue() {
        return this.value;
    }

    public T getStep() {
        return this.step;
    }

    public void setStep(T t) {
        this.step = t;
    }

    public T getMaxValue() {
        return this.maxValue;
    }

    public void setMaxValue(T t) {
        this.maxValue = t;
    }

    public T getMinValue() {
        return this.minValue;
    }

    public void setMinValue(T t) {
        this.minValue = t;
    }
}

